/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteAlarmsRequestMarshaller
implements Marshaller<Request<DeleteAlarmsRequest>, DeleteAlarmsRequest> {
    @Override
    public Request<DeleteAlarmsRequest> marshall(DeleteAlarmsRequest deleteAlarmsRequest) {
        if (deleteAlarmsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteAlarmsRequest> request = new DefaultRequest<DeleteAlarmsRequest>(deleteAlarmsRequest, "AmazonCloudWatch");
        request.addParameter("Action", "DeleteAlarms");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList alarmNamesList = (SdkInternalList)deleteAlarmsRequest.getAlarmNames();
        if (!alarmNamesList.isEmpty() || !alarmNamesList.isAutoConstruct()) {
            int alarmNamesListIndex = 1;
            for (String alarmNamesListValue : alarmNamesList) {
                if (alarmNamesListValue != null) {
                    request.addParameter("AlarmNames.member." + alarmNamesListIndex, StringUtils.fromString(alarmNamesListValue));
                }
                ++alarmNamesListIndex;
            }
        }
        return request;
    }
}

