/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudtrail.model.CreateTrailRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class CreateTrailRequestMarshaller
implements Marshaller<Request<CreateTrailRequest>, CreateTrailRequest> {
    @Override
    public Request<CreateTrailRequest> marshall(CreateTrailRequest createTrailRequest) {
        if (createTrailRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateTrailRequest> request = new DefaultRequest<CreateTrailRequest>(createTrailRequest, "AWSCloudTrail");
        request.addHeader("X-Amz-Target", "com.amazonaws.cloudtrail.v20131101.CloudTrail_20131101.CreateTrail");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (createTrailRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createTrailRequest.getName());
            }
            if (createTrailRequest.getS3BucketName() != null) {
                jsonGenerator.writeFieldName("S3BucketName").writeValue(createTrailRequest.getS3BucketName());
            }
            if (createTrailRequest.getS3KeyPrefix() != null) {
                jsonGenerator.writeFieldName("S3KeyPrefix").writeValue(createTrailRequest.getS3KeyPrefix());
            }
            if (createTrailRequest.getSnsTopicName() != null) {
                jsonGenerator.writeFieldName("SnsTopicName").writeValue(createTrailRequest.getSnsTopicName());
            }
            if (createTrailRequest.getIncludeGlobalServiceEvents() != null) {
                jsonGenerator.writeFieldName("IncludeGlobalServiceEvents").writeValue(createTrailRequest.getIncludeGlobalServiceEvents());
            }
            if (createTrailRequest.getIsMultiRegionTrail() != null) {
                jsonGenerator.writeFieldName("IsMultiRegionTrail").writeValue(createTrailRequest.getIsMultiRegionTrail());
            }
            if (createTrailRequest.getEnableLogFileValidation() != null) {
                jsonGenerator.writeFieldName("EnableLogFileValidation").writeValue(createTrailRequest.getEnableLogFileValidation());
            }
            if (createTrailRequest.getCloudWatchLogsLogGroupArn() != null) {
                jsonGenerator.writeFieldName("CloudWatchLogsLogGroupArn").writeValue(createTrailRequest.getCloudWatchLogsLogGroupArn());
            }
            if (createTrailRequest.getCloudWatchLogsRoleArn() != null) {
                jsonGenerator.writeFieldName("CloudWatchLogsRoleArn").writeValue(createTrailRequest.getCloudWatchLogsRoleArn());
            }
            if (createTrailRequest.getKmsKeyId() != null) {
                jsonGenerator.writeFieldName("KmsKeyId").writeValue(createTrailRequest.getKmsKeyId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

