/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.codecommit.model.UpdateRepositoryNameRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class UpdateRepositoryNameRequestMarshaller
implements Marshaller<Request<UpdateRepositoryNameRequest>, UpdateRepositoryNameRequest> {
    @Override
    public Request<UpdateRepositoryNameRequest> marshall(UpdateRepositoryNameRequest updateRepositoryNameRequest) {
        if (updateRepositoryNameRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateRepositoryNameRequest> request = new DefaultRequest<UpdateRepositoryNameRequest>(updateRepositoryNameRequest, "AWSCodeCommit");
        request.addHeader("X-Amz-Target", "CodeCommit_20150413.UpdateRepositoryName");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (updateRepositoryNameRequest.getOldName() != null) {
                jsonGenerator.writeFieldName("oldName").writeValue(updateRepositoryNameRequest.getOldName());
            }
            if (updateRepositoryNameRequest.getNewName() != null) {
                jsonGenerator.writeFieldName("newName").writeValue(updateRepositoryNameRequest.getNewName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

