/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.opsworks.model.StackSummary;
import com.amazonaws.services.opsworks.model.transform.InstancesCountJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class StackSummaryJsonMarshaller {
    private static StackSummaryJsonMarshaller instance;

    public void marshall(StackSummary stackSummary, StructuredJsonGenerator jsonGenerator) {
        if (stackSummary == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (stackSummary.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(stackSummary.getStackId());
            }
            if (stackSummary.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(stackSummary.getName());
            }
            if (stackSummary.getArn() != null) {
                jsonGenerator.writeFieldName("Arn").writeValue(stackSummary.getArn());
            }
            if (stackSummary.getLayersCount() != null) {
                jsonGenerator.writeFieldName("LayersCount").writeValue(stackSummary.getLayersCount());
            }
            if (stackSummary.getAppsCount() != null) {
                jsonGenerator.writeFieldName("AppsCount").writeValue(stackSummary.getAppsCount());
            }
            if (stackSummary.getInstancesCount() != null) {
                jsonGenerator.writeFieldName("InstancesCount");
                InstancesCountJsonMarshaller.getInstance().marshall(stackSummary.getInstancesCount(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StackSummaryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StackSummaryJsonMarshaller();
        }
        return instance;
    }
}

