/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ecs.model.RunTaskRequest;
import com.amazonaws.services.ecs.model.transform.TaskOverrideJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class RunTaskRequestMarshaller
implements Marshaller<Request<RunTaskRequest>, RunTaskRequest> {
    @Override
    public Request<RunTaskRequest> marshall(RunTaskRequest runTaskRequest) {
        if (runTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RunTaskRequest> request = new DefaultRequest<RunTaskRequest>(runTaskRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.RunTask");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (runTaskRequest.getCluster() != null) {
                jsonGenerator.writeFieldName("cluster").writeValue(runTaskRequest.getCluster());
            }
            if (runTaskRequest.getTaskDefinition() != null) {
                jsonGenerator.writeFieldName("taskDefinition").writeValue(runTaskRequest.getTaskDefinition());
            }
            if (runTaskRequest.getOverrides() != null) {
                jsonGenerator.writeFieldName("overrides");
                TaskOverrideJsonMarshaller.getInstance().marshall(runTaskRequest.getOverrides(), jsonGenerator);
            }
            if (runTaskRequest.getCount() != null) {
                jsonGenerator.writeFieldName("count").writeValue(runTaskRequest.getCount());
            }
            if (runTaskRequest.getStartedBy() != null) {
                jsonGenerator.writeFieldName("startedBy").writeValue(runTaskRequest.getStartedBy());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

