/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.directory.model.ConnectDirectoryRequest;
import com.amazonaws.services.directory.model.transform.DirectoryConnectSettingsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class ConnectDirectoryRequestMarshaller
implements Marshaller<Request<ConnectDirectoryRequest>, ConnectDirectoryRequest> {
    @Override
    public Request<ConnectDirectoryRequest> marshall(ConnectDirectoryRequest connectDirectoryRequest) {
        if (connectDirectoryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ConnectDirectoryRequest> request = new DefaultRequest<ConnectDirectoryRequest>(connectDirectoryRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.ConnectDirectory");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (connectDirectoryRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(connectDirectoryRequest.getName());
            }
            if (connectDirectoryRequest.getShortName() != null) {
                jsonGenerator.writeFieldName("ShortName").writeValue(connectDirectoryRequest.getShortName());
            }
            if (connectDirectoryRequest.getPassword() != null) {
                jsonGenerator.writeFieldName("Password").writeValue(connectDirectoryRequest.getPassword());
            }
            if (connectDirectoryRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(connectDirectoryRequest.getDescription());
            }
            if (connectDirectoryRequest.getSize() != null) {
                jsonGenerator.writeFieldName("Size").writeValue(connectDirectoryRequest.getSize());
            }
            if (connectDirectoryRequest.getConnectSettings() != null) {
                jsonGenerator.writeFieldName("ConnectSettings");
                DirectoryConnectSettingsJsonMarshaller.getInstance().marshall(connectDirectoryRequest.getConnectSettings(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

