/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.datapipeline.model.Selector;
import com.amazonaws.services.datapipeline.model.transform.OperatorJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class SelectorJsonMarshaller {
    private static SelectorJsonMarshaller instance;

    public void marshall(Selector selector, StructuredJsonGenerator jsonGenerator) {
        if (selector == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (selector.getFieldName() != null) {
                jsonGenerator.writeFieldName("fieldName").writeValue(selector.getFieldName());
            }
            if (selector.getOperator() != null) {
                jsonGenerator.writeFieldName("operator");
                OperatorJsonMarshaller.getInstance().marshall(selector.getOperator(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SelectorJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SelectorJsonMarshaller();
        }
        return instance;
    }
}

