/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.datapipeline.model.AddTagsRequest;
import com.amazonaws.services.datapipeline.model.Tag;
import com.amazonaws.services.datapipeline.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class AddTagsRequestMarshaller
implements Marshaller<Request<AddTagsRequest>, AddTagsRequest> {
    @Override
    public Request<AddTagsRequest> marshall(AddTagsRequest addTagsRequest) {
        if (addTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddTagsRequest> request = new DefaultRequest<AddTagsRequest>(addTagsRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.AddTags");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList tagsList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (addTagsRequest.getPipelineId() != null) {
                jsonGenerator.writeFieldName("pipelineId").writeValue(addTagsRequest.getPipelineId());
            }
            if (!(tagsList = (SdkInternalList)addTagsRequest.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("tags");
                jsonGenerator.writeStartArray();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

