/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevents.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudwatchevents.model.ListRulesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class ListRulesRequestMarshaller
implements Marshaller<Request<ListRulesRequest>, ListRulesRequest> {
    @Override
    public Request<ListRulesRequest> marshall(ListRulesRequest listRulesRequest) {
        if (listRulesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListRulesRequest> request = new DefaultRequest<ListRulesRequest>(listRulesRequest, "AmazonCloudWatchEvents");
        request.addHeader("X-Amz-Target", "AWSEvents.ListRules");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (listRulesRequest.getNamePrefix() != null) {
                jsonGenerator.writeFieldName("NamePrefix").writeValue(listRulesRequest.getNamePrefix());
            }
            if (listRulesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listRulesRequest.getNextToken());
            }
            if (listRulesRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listRulesRequest.getLimit());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

