/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.ListAssessmentTemplatesRequest;
import com.amazonaws.services.inspector.model.transform.AssessmentTemplateFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.util.List;

public class ListAssessmentTemplatesRequestMarshaller
implements Marshaller<Request<ListAssessmentTemplatesRequest>, ListAssessmentTemplatesRequest> {
    @Override
    public Request<ListAssessmentTemplatesRequest> marshall(ListAssessmentTemplatesRequest listAssessmentTemplatesRequest) {
        if (listAssessmentTemplatesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListAssessmentTemplatesRequest> request = new DefaultRequest<ListAssessmentTemplatesRequest>(listAssessmentTemplatesRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.ListAssessmentTemplates");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            List<String> assessmentTargetArnsList = listAssessmentTemplatesRequest.getAssessmentTargetArns();
            if (assessmentTargetArnsList != null) {
                jsonGenerator.writeFieldName("assessmentTargetArns");
                jsonGenerator.writeStartArray();
                for (String assessmentTargetArnsListValue : assessmentTargetArnsList) {
                    if (assessmentTargetArnsListValue == null) continue;
                    jsonGenerator.writeValue(assessmentTargetArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (listAssessmentTemplatesRequest.getFilter() != null) {
                jsonGenerator.writeFieldName("filter");
                AssessmentTemplateFilterJsonMarshaller.getInstance().marshall(listAssessmentTemplatesRequest.getFilter(), jsonGenerator);
            }
            if (listAssessmentTemplatesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listAssessmentTemplatesRequest.getNextToken());
            }
            if (listAssessmentTemplatesRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(listAssessmentTemplatesRequest.getMaxResults());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

