/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.identitymanagement.model.ContextEntry;
import com.amazonaws.services.identitymanagement.model.SimulateCustomPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SimulateCustomPolicyRequestMarshaller
implements Marshaller<Request<SimulateCustomPolicyRequest>, SimulateCustomPolicyRequest> {
    @Override
    public Request<SimulateCustomPolicyRequest> marshall(SimulateCustomPolicyRequest simulateCustomPolicyRequest) {
        SdkInternalList contextEntriesList;
        SdkInternalList resourceArnsList;
        SdkInternalList actionNamesList;
        if (simulateCustomPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SimulateCustomPolicyRequest> request = new DefaultRequest<SimulateCustomPolicyRequest>(simulateCustomPolicyRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "SimulateCustomPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList policyInputListList = (SdkInternalList)simulateCustomPolicyRequest.getPolicyInputList();
        if (!policyInputListList.isEmpty() || !policyInputListList.isAutoConstruct()) {
            int policyInputListListIndex = 1;
            for (String policyInputListListValue : policyInputListList) {
                if (policyInputListListValue != null) {
                    request.addParameter("PolicyInputList.member." + policyInputListListIndex, StringUtils.fromString(policyInputListListValue));
                }
                ++policyInputListListIndex;
            }
        }
        if (!(actionNamesList = (SdkInternalList)simulateCustomPolicyRequest.getActionNames()).isEmpty() || !actionNamesList.isAutoConstruct()) {
            int actionNamesListIndex = 1;
            for (String actionNamesListValue : actionNamesList) {
                if (actionNamesListValue != null) {
                    request.addParameter("ActionNames.member." + actionNamesListIndex, StringUtils.fromString(actionNamesListValue));
                }
                ++actionNamesListIndex;
            }
        }
        if (!(resourceArnsList = (SdkInternalList)simulateCustomPolicyRequest.getResourceArns()).isEmpty() || !resourceArnsList.isAutoConstruct()) {
            int resourceArnsListIndex = 1;
            for (String resourceArnsListValue : resourceArnsList) {
                if (resourceArnsListValue != null) {
                    request.addParameter("ResourceArns.member." + resourceArnsListIndex, StringUtils.fromString(resourceArnsListValue));
                }
                ++resourceArnsListIndex;
            }
        }
        if (simulateCustomPolicyRequest.getResourcePolicy() != null) {
            request.addParameter("ResourcePolicy", StringUtils.fromString(simulateCustomPolicyRequest.getResourcePolicy()));
        }
        if (simulateCustomPolicyRequest.getResourceOwner() != null) {
            request.addParameter("ResourceOwner", StringUtils.fromString(simulateCustomPolicyRequest.getResourceOwner()));
        }
        if (simulateCustomPolicyRequest.getCallerArn() != null) {
            request.addParameter("CallerArn", StringUtils.fromString(simulateCustomPolicyRequest.getCallerArn()));
        }
        if (!(contextEntriesList = (SdkInternalList)simulateCustomPolicyRequest.getContextEntries()).isEmpty() || !contextEntriesList.isAutoConstruct()) {
            int contextEntriesListIndex = 1;
            for (ContextEntry contextEntriesListValue : contextEntriesList) {
                SdkInternalList contextKeyValuesList;
                if (contextEntriesListValue.getContextKeyName() != null) {
                    request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyName", StringUtils.fromString(contextEntriesListValue.getContextKeyName()));
                }
                if (!(contextKeyValuesList = (SdkInternalList)contextEntriesListValue.getContextKeyValues()).isEmpty() || !contextKeyValuesList.isAutoConstruct()) {
                    int contextKeyValuesListIndex = 1;
                    for (String contextKeyValuesListValue : contextKeyValuesList) {
                        if (contextKeyValuesListValue != null) {
                            request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyValues.member." + contextKeyValuesListIndex, StringUtils.fromString(contextKeyValuesListValue));
                        }
                        ++contextKeyValuesListIndex;
                    }
                }
                if (contextEntriesListValue.getContextKeyType() != null) {
                    request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyType", StringUtils.fromString(contextEntriesListValue.getContextKeyType()));
                }
                ++contextEntriesListIndex;
            }
        }
        if (simulateCustomPolicyRequest.getResourceHandlingOption() != null) {
            request.addParameter("ResourceHandlingOption", StringUtils.fromString(simulateCustomPolicyRequest.getResourceHandlingOption()));
        }
        if (simulateCustomPolicyRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger(simulateCustomPolicyRequest.getMaxItems()));
        }
        if (simulateCustomPolicyRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(simulateCustomPolicyRequest.getMarker()));
        }
        return request;
    }
}

