/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticloadbalancing.model.Listener;
import com.amazonaws.services.elasticloadbalancing.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateLoadBalancerRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String loadBalancerName;
    private SdkInternalList<Listener> listeners;
    private SdkInternalList<String> availabilityZones;
    private SdkInternalList<String> subnets;
    private SdkInternalList<String> securityGroups;
    private String scheme;
    private SdkInternalList<Tag> tags;

    public CreateLoadBalancerRequest() {
    }

    public CreateLoadBalancerRequest(String loadBalancerName) {
        this.setLoadBalancerName(loadBalancerName);
    }

    public CreateLoadBalancerRequest(String loadBalancerName, List<Listener> listeners, List<String> availabilityZones) {
        this.setLoadBalancerName(loadBalancerName);
        this.setListeners(listeners);
        this.setAvailabilityZones(availabilityZones);
    }

    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    public CreateLoadBalancerRequest withLoadBalancerName(String loadBalancerName) {
        this.setLoadBalancerName(loadBalancerName);
        return this;
    }

    public List<Listener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new SdkInternalList();
        }
        return this.listeners;
    }

    public void setListeners(Collection<Listener> listeners) {
        if (listeners == null) {
            this.listeners = null;
            return;
        }
        this.listeners = new SdkInternalList<Listener>(listeners);
    }

    public CreateLoadBalancerRequest withListeners(Listener ... listeners) {
        if (this.listeners == null) {
            this.setListeners(new SdkInternalList<Listener>(listeners.length));
        }
        for (Listener ele : listeners) {
            this.listeners.add(ele);
        }
        return this;
    }

    public CreateLoadBalancerRequest withListeners(Collection<Listener> listeners) {
        this.setListeners(listeners);
        return this;
    }

    public List<String> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new SdkInternalList();
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        this.availabilityZones = new SdkInternalList<String>(availabilityZones);
    }

    public CreateLoadBalancerRequest withAvailabilityZones(String ... availabilityZones) {
        if (this.availabilityZones == null) {
            this.setAvailabilityZones(new SdkInternalList<String>(availabilityZones.length));
        }
        for (String ele : availabilityZones) {
            this.availabilityZones.add(ele);
        }
        return this;
    }

    public CreateLoadBalancerRequest withAvailabilityZones(Collection<String> availabilityZones) {
        this.setAvailabilityZones(availabilityZones);
        return this;
    }

    public List<String> getSubnets() {
        if (this.subnets == null) {
            this.subnets = new SdkInternalList();
        }
        return this.subnets;
    }

    public void setSubnets(Collection<String> subnets) {
        if (subnets == null) {
            this.subnets = null;
            return;
        }
        this.subnets = new SdkInternalList<String>(subnets);
    }

    public CreateLoadBalancerRequest withSubnets(String ... subnets) {
        if (this.subnets == null) {
            this.setSubnets(new SdkInternalList<String>(subnets.length));
        }
        for (String ele : subnets) {
            this.subnets.add(ele);
        }
        return this;
    }

    public CreateLoadBalancerRequest withSubnets(Collection<String> subnets) {
        this.setSubnets(subnets);
        return this;
    }

    public List<String> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new SdkInternalList();
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new SdkInternalList<String>(securityGroups);
    }

    public CreateLoadBalancerRequest withSecurityGroups(String ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups(new SdkInternalList<String>(securityGroups.length));
        }
        for (String ele : securityGroups) {
            this.securityGroups.add(ele);
        }
        return this;
    }

    public CreateLoadBalancerRequest withSecurityGroups(Collection<String> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    public CreateLoadBalancerRequest withScheme(String scheme) {
        this.setScheme(scheme);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public CreateLoadBalancerRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateLoadBalancerRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLoadBalancerName() != null) {
            sb.append("LoadBalancerName: " + this.getLoadBalancerName() + ",");
        }
        if (this.getListeners() != null) {
            sb.append("Listeners: " + this.getListeners() + ",");
        }
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: " + this.getAvailabilityZones() + ",");
        }
        if (this.getSubnets() != null) {
            sb.append("Subnets: " + this.getSubnets() + ",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: " + this.getSecurityGroups() + ",");
        }
        if (this.getScheme() != null) {
            sb.append("Scheme: " + this.getScheme() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerRequest)) {
            return false;
        }
        CreateLoadBalancerRequest other = (CreateLoadBalancerRequest)obj;
        if (other.getLoadBalancerName() == null ^ this.getLoadBalancerName() == null) {
            return false;
        }
        if (other.getLoadBalancerName() != null && !other.getLoadBalancerName().equals(this.getLoadBalancerName())) {
            return false;
        }
        if (other.getListeners() == null ^ this.getListeners() == null) {
            return false;
        }
        if (other.getListeners() != null && !other.getListeners().equals(this.getListeners())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !other.getAvailabilityZones().equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getSubnets() == null ^ this.getSubnets() == null) {
            return false;
        }
        if (other.getSubnets() != null && !other.getSubnets().equals(this.getSubnets())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !other.getSecurityGroups().equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getScheme() == null ^ this.getScheme() == null) {
            return false;
        }
        if (other.getScheme() != null && !other.getScheme().equals(this.getScheme())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLoadBalancerName() == null ? 0 : this.getLoadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.getListeners() == null ? 0 : this.getListeners().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : this.getAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.getSubnets() == null ? 0 : this.getSubnets().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getScheme() == null ? 0 : this.getScheme().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateLoadBalancerRequest clone() {
        return (CreateLoadBalancerRequest)super.clone();
    }
}

