/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directory.model.DirectoryConnectSettings;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class DirectoryConnectSettingsJsonMarshaller {
    private static DirectoryConnectSettingsJsonMarshaller instance;

    public void marshall(DirectoryConnectSettings directoryConnectSettings, StructuredJsonGenerator jsonGenerator) {
        if (directoryConnectSettings == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList customerDnsIpsList;
            SdkInternalList subnetIdsList;
            jsonGenerator.writeStartObject();
            if (directoryConnectSettings.getVpcId() != null) {
                jsonGenerator.writeFieldName("VpcId").writeValue(directoryConnectSettings.getVpcId());
            }
            if (!(subnetIdsList = (SdkInternalList)directoryConnectSettings.getSubnetIds()).isEmpty() || !subnetIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("SubnetIds");
                jsonGenerator.writeStartArray();
                for (String subnetIdsListValue : subnetIdsList) {
                    if (subnetIdsListValue == null) continue;
                    jsonGenerator.writeValue(subnetIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(customerDnsIpsList = (SdkInternalList)directoryConnectSettings.getCustomerDnsIps()).isEmpty() || !customerDnsIpsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("CustomerDnsIps");
                jsonGenerator.writeStartArray();
                for (String customerDnsIpsListValue : customerDnsIpsList) {
                    if (customerDnsIpsListValue == null) continue;
                    jsonGenerator.writeValue(customerDnsIpsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (directoryConnectSettings.getCustomerUserName() != null) {
                jsonGenerator.writeFieldName("CustomerUserName").writeValue(directoryConnectSettings.getCustomerUserName());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DirectoryConnectSettingsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DirectoryConnectSettingsJsonMarshaller();
        }
        return instance;
    }
}

