/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.directory.model.CreateMicrosoftADRequest;
import com.amazonaws.services.directory.model.transform.DirectoryVpcSettingsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class CreateMicrosoftADRequestMarshaller
implements Marshaller<Request<CreateMicrosoftADRequest>, CreateMicrosoftADRequest> {
    @Override
    public Request<CreateMicrosoftADRequest> marshall(CreateMicrosoftADRequest createMicrosoftADRequest) {
        if (createMicrosoftADRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateMicrosoftADRequest> request = new DefaultRequest<CreateMicrosoftADRequest>(createMicrosoftADRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.CreateMicrosoftAD");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (createMicrosoftADRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createMicrosoftADRequest.getName());
            }
            if (createMicrosoftADRequest.getShortName() != null) {
                jsonGenerator.writeFieldName("ShortName").writeValue(createMicrosoftADRequest.getShortName());
            }
            if (createMicrosoftADRequest.getPassword() != null) {
                jsonGenerator.writeFieldName("Password").writeValue(createMicrosoftADRequest.getPassword());
            }
            if (createMicrosoftADRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(createMicrosoftADRequest.getDescription());
            }
            if (createMicrosoftADRequest.getVpcSettings() != null) {
                jsonGenerator.writeFieldName("VpcSettings");
                DirectoryVpcSettingsJsonMarshaller.getInstance().marshall(createMicrosoftADRequest.getVpcSettings(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

