/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.devicefarm.model.Problem;
import com.amazonaws.services.devicefarm.model.transform.DeviceJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.ProblemDetailJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class ProblemJsonMarshaller {
    private static ProblemJsonMarshaller instance;

    public void marshall(Problem problem, StructuredJsonGenerator jsonGenerator) {
        if (problem == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (problem.getRun() != null) {
                jsonGenerator.writeFieldName("run");
                ProblemDetailJsonMarshaller.getInstance().marshall(problem.getRun(), jsonGenerator);
            }
            if (problem.getJob() != null) {
                jsonGenerator.writeFieldName("job");
                ProblemDetailJsonMarshaller.getInstance().marshall(problem.getJob(), jsonGenerator);
            }
            if (problem.getSuite() != null) {
                jsonGenerator.writeFieldName("suite");
                ProblemDetailJsonMarshaller.getInstance().marshall(problem.getSuite(), jsonGenerator);
            }
            if (problem.getTest() != null) {
                jsonGenerator.writeFieldName("test");
                ProblemDetailJsonMarshaller.getInstance().marshall(problem.getTest(), jsonGenerator);
            }
            if (problem.getDevice() != null) {
                jsonGenerator.writeFieldName("device");
                DeviceJsonMarshaller.getInstance().marshall(problem.getDevice(), jsonGenerator);
            }
            if (problem.getResult() != null) {
                jsonGenerator.writeFieldName("result").writeValue(problem.getResult());
            }
            if (problem.getMessage() != null) {
                jsonGenerator.writeFieldName("message").writeValue(problem.getMessage());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ProblemJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ProblemJsonMarshaller();
        }
        return instance;
    }
}

