/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.CreateModelRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;

public class CreateModelRequestMarshaller
implements Marshaller<Request<CreateModelRequest>, CreateModelRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<CreateModelRequest> marshall(CreateModelRequest createModelRequest) {
        if (createModelRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateModelRequest> request = new DefaultRequest<CreateModelRequest>(createModelRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/restapis/{restapi_id}/models";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", createModelRequest.getRestApiId() != null ? StringUtils.fromString(createModelRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (createModelRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(createModelRequest.getName());
            }
            if (createModelRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(createModelRequest.getDescription());
            }
            if (createModelRequest.getSchema() != null) {
                jsonGenerator.writeFieldName("schema").writeValue(createModelRequest.getSchema());
            }
            if (createModelRequest.getContentType() != null) {
                jsonGenerator.writeFieldName("contentType").writeValue(createModelRequest.getContentType());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

