/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model;

import com.amazonaws.services.apigateway.model.MethodSnapshot;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Deployment
implements Serializable,
Cloneable {
    private String id;
    private String description;
    private Date createdDate;
    private Map<String, Map<String, MethodSnapshot>> apiSummary;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Deployment withId(String id) {
        this.setId(id);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Deployment withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public Deployment withCreatedDate(Date createdDate) {
        this.setCreatedDate(createdDate);
        return this;
    }

    public Map<String, Map<String, MethodSnapshot>> getApiSummary() {
        return this.apiSummary;
    }

    public void setApiSummary(Map<String, Map<String, MethodSnapshot>> apiSummary) {
        this.apiSummary = apiSummary;
    }

    public Deployment withApiSummary(Map<String, Map<String, MethodSnapshot>> apiSummary) {
        this.setApiSummary(apiSummary);
        return this;
    }

    public Deployment addApiSummaryEntry(String key, Map<String, MethodSnapshot> value) {
        if (null == this.apiSummary) {
            this.apiSummary = new HashMap<String, Map<String, MethodSnapshot>>();
        }
        if (this.apiSummary.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.apiSummary.put(key, value);
        return this;
    }

    public Deployment clearApiSummaryEntries() {
        this.apiSummary = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: " + this.getId() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getCreatedDate() != null) {
            sb.append("CreatedDate: " + this.getCreatedDate() + ",");
        }
        if (this.getApiSummary() != null) {
            sb.append("ApiSummary: " + this.getApiSummary());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getCreatedDate() == null ^ this.getCreatedDate() == null) {
            return false;
        }
        if (other.getCreatedDate() != null && !other.getCreatedDate().equals(this.getCreatedDate())) {
            return false;
        }
        if (other.getApiSummary() == null ^ this.getApiSummary() == null) {
            return false;
        }
        return other.getApiSummary() == null || other.getApiSummary().equals(this.getApiSummary());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedDate() == null ? 0 : this.getCreatedDate().hashCode());
        hashCode = 31 * hashCode + (this.getApiSummary() == null ? 0 : this.getApiSummary().hashCode());
        return hashCode;
    }

    public Deployment clone() {
        try {
            return (Deployment)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

