/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.opsworks.model.DataSource;
import com.amazonaws.services.opsworks.model.EnvironmentVariable;
import com.amazonaws.services.opsworks.model.UpdateAppRequest;
import com.amazonaws.services.opsworks.model.transform.DataSourceJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.EnvironmentVariableJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.SourceJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.SslConfigurationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Map;

public class UpdateAppRequestMarshaller
implements Marshaller<Request<UpdateAppRequest>, UpdateAppRequest> {
    @Override
    public Request<UpdateAppRequest> marshall(UpdateAppRequest updateAppRequest) {
        if (updateAppRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateAppRequest> request = new DefaultRequest<UpdateAppRequest>(updateAppRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.UpdateApp");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList environmentList;
            SdkInternalMap attributesMap;
            SdkInternalList domainsList;
            SdkInternalList dataSourcesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (updateAppRequest.getAppId() != null) {
                jsonWriter.key("AppId").value(updateAppRequest.getAppId());
            }
            if (updateAppRequest.getName() != null) {
                jsonWriter.key("Name").value(updateAppRequest.getName());
            }
            if (updateAppRequest.getDescription() != null) {
                jsonWriter.key("Description").value(updateAppRequest.getDescription());
            }
            if (!(dataSourcesList = (SdkInternalList)updateAppRequest.getDataSources()).isEmpty() || !dataSourcesList.isAutoConstruct()) {
                jsonWriter.key("DataSources");
                jsonWriter.array();
                for (DataSource dataSourcesListValue : dataSourcesList) {
                    if (dataSourcesListValue == null) continue;
                    DataSourceJsonMarshaller.getInstance().marshall(dataSourcesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (updateAppRequest.getType() != null) {
                jsonWriter.key("Type").value(updateAppRequest.getType());
            }
            if (updateAppRequest.getAppSource() != null) {
                jsonWriter.key("AppSource");
                SourceJsonMarshaller.getInstance().marshall(updateAppRequest.getAppSource(), jsonWriter);
            }
            if (!(domainsList = (SdkInternalList)updateAppRequest.getDomains()).isEmpty() || !domainsList.isAutoConstruct()) {
                jsonWriter.key("Domains");
                jsonWriter.array();
                for (String domainsListValue : domainsList) {
                    if (domainsListValue == null) continue;
                    jsonWriter.value(domainsListValue);
                }
                jsonWriter.endArray();
            }
            if (updateAppRequest.getEnableSsl() != null) {
                jsonWriter.key("EnableSsl").value(updateAppRequest.getEnableSsl());
            }
            if (updateAppRequest.getSslConfiguration() != null) {
                jsonWriter.key("SslConfiguration");
                SslConfigurationJsonMarshaller.getInstance().marshall(updateAppRequest.getSslConfiguration(), jsonWriter);
            }
            if (!(attributesMap = (SdkInternalMap)updateAppRequest.getAttributes()).isEmpty() || !attributesMap.isAutoConstruct()) {
                jsonWriter.key("Attributes");
                jsonWriter.object();
                for (Map.Entry attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonWriter.key((String)attributesMapValue.getKey());
                    jsonWriter.value(attributesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (!(environmentList = (SdkInternalList)updateAppRequest.getEnvironment()).isEmpty() || !environmentList.isAutoConstruct()) {
                jsonWriter.key("Environment");
                jsonWriter.array();
                for (EnvironmentVariable environmentListValue : environmentList) {
                    if (environmentListValue == null) continue;
                    EnvironmentVariableJsonMarshaller.getInstance().marshall(environmentListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

