/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.importexport.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.importexport.model.CancelJobRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CancelJobRequestMarshaller
implements Marshaller<Request<CancelJobRequest>, CancelJobRequest> {
    @Override
    public Request<CancelJobRequest> marshall(CancelJobRequest cancelJobRequest) {
        if (cancelJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CancelJobRequest> request = new DefaultRequest<CancelJobRequest>(cancelJobRequest, "AmazonImportExport");
        request.addParameter("Action", "CancelJob");
        request.addParameter("Version", "2010-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (cancelJobRequest.getJobId() != null) {
            request.addParameter("JobId", StringUtils.fromString(cancelJobRequest.getJobId()));
        }
        if (cancelJobRequest.getAPIVersion() != null) {
            request.addParameter("APIVersion", StringUtils.fromString(cancelJobRequest.getAPIVersion()));
        }
        return request;
    }
}

