/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticsearch.model.AddTagsRequest;
import com.amazonaws.services.elasticsearch.model.Tag;
import com.amazonaws.services.elasticsearch.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class AddTagsRequestMarshaller
implements Marshaller<Request<AddTagsRequest>, AddTagsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<AddTagsRequest> marshall(AddTagsRequest addTagsRequest) {
        if (addTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddTagsRequest> request = new DefaultRequest<AddTagsRequest>(addTagsRequest, "AWSElasticsearch");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2015-01-01/tags";
        request.setResourcePath(uriResourcePath);
        try {
            List<Tag> tagListList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (addTagsRequest.getARN() != null) {
                jsonWriter.key("ARN").value(addTagsRequest.getARN());
            }
            if ((tagListList = addTagsRequest.getTagList()) != null) {
                jsonWriter.key("TagList");
                jsonWriter.array();
                for (Tag tagListListValue : tagListList) {
                    if (tagListListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagListListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

