/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ecs.model.Cluster;
import com.amazonaws.util.json.JSONWriter;

public class ClusterJsonMarshaller {
    private static ClusterJsonMarshaller instance;

    public void marshall(Cluster cluster, JSONWriter jsonWriter) {
        if (cluster == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (cluster.getClusterArn() != null) {
                jsonWriter.key("clusterArn").value(cluster.getClusterArn());
            }
            if (cluster.getClusterName() != null) {
                jsonWriter.key("clusterName").value(cluster.getClusterName());
            }
            if (cluster.getStatus() != null) {
                jsonWriter.key("status").value(cluster.getStatus());
            }
            if (cluster.getRegisteredContainerInstancesCount() != null) {
                jsonWriter.key("registeredContainerInstancesCount").value(cluster.getRegisteredContainerInstancesCount());
            }
            if (cluster.getRunningTasksCount() != null) {
                jsonWriter.key("runningTasksCount").value(cluster.getRunningTasksCount());
            }
            if (cluster.getPendingTasksCount() != null) {
                jsonWriter.key("pendingTasksCount").value(cluster.getPendingTasksCount());
            }
            if (cluster.getActiveServicesCount() != null) {
                jsonWriter.key("activeServicesCount").value(cluster.getActiveServicesCount());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ClusterJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ClusterJsonMarshaller();
        }
        return instance;
    }
}

