/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ecr.model.Layer;
import com.amazonaws.util.json.JSONWriter;

public class LayerJsonMarshaller {
    private static LayerJsonMarshaller instance;

    public void marshall(Layer layer, JSONWriter jsonWriter) {
        if (layer == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (layer.getLayerDigest() != null) {
                jsonWriter.key("layerDigest").value(layer.getLayerDigest());
            }
            if (layer.getLayerAvailability() != null) {
                jsonWriter.key("layerAvailability").value(layer.getLayerAvailability());
            }
            if (layer.getLayerSize() != null) {
                jsonWriter.key("layerSize").value(layer.getLayerSize());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LayerJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LayerJsonMarshaller();
        }
        return instance;
    }
}

