/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitosync.model.GetCognitoEventsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetCognitoEventsRequestMarshaller
implements Marshaller<Request<GetCognitoEventsRequest>, GetCognitoEventsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";

    @Override
    public Request<GetCognitoEventsRequest> marshall(GetCognitoEventsRequest getCognitoEventsRequest) {
        if (getCognitoEventsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetCognitoEventsRequest> request = new DefaultRequest<GetCognitoEventsRequest>(getCognitoEventsRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/events";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", getCognitoEventsRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString(getCognitoEventsRequest.getIdentityPoolId()));
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

