/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.certificatemanager.model.DomainValidation;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class DomainValidationJsonMarshaller {
    private static DomainValidationJsonMarshaller instance;

    public void marshall(DomainValidation domainValidation, JSONWriter jsonWriter) {
        if (domainValidation == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> validationEmailsList;
            jsonWriter.object();
            if (domainValidation.getDomainName() != null) {
                jsonWriter.key("DomainName").value(domainValidation.getDomainName());
            }
            if ((validationEmailsList = domainValidation.getValidationEmails()) != null) {
                jsonWriter.key("ValidationEmails");
                jsonWriter.array();
                for (String validationEmailsListValue : validationEmailsList) {
                    if (validationEmailsListValue == null) continue;
                    jsonWriter.value(validationEmailsListValue);
                }
                jsonWriter.endArray();
            }
            if (domainValidation.getValidationDomain() != null) {
                jsonWriter.key("ValidationDomain").value(domainValidation.getValidationDomain());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DomainValidationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DomainValidationJsonMarshaller();
        }
        return instance;
    }
}

