/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.waf.model.ActivatedRule;
import com.amazonaws.services.waf.model.WebACL;
import com.amazonaws.services.waf.model.transform.ActivatedRuleJsonMarshaller;
import com.amazonaws.services.waf.model.transform.WafActionJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class WebACLJsonMarshaller {
    private static WebACLJsonMarshaller instance;

    public void marshall(WebACL webACL, JSONWriter jsonWriter) {
        if (webACL == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<ActivatedRule> rulesList;
            jsonWriter.object();
            if (webACL.getWebACLId() != null) {
                jsonWriter.key("WebACLId").value(webACL.getWebACLId());
            }
            if (webACL.getName() != null) {
                jsonWriter.key("Name").value(webACL.getName());
            }
            if (webACL.getMetricName() != null) {
                jsonWriter.key("MetricName").value(webACL.getMetricName());
            }
            if (webACL.getDefaultAction() != null) {
                jsonWriter.key("DefaultAction");
                WafActionJsonMarshaller.getInstance().marshall(webACL.getDefaultAction(), jsonWriter);
            }
            if ((rulesList = webACL.getRules()) != null) {
                jsonWriter.key("Rules");
                jsonWriter.array();
                for (ActivatedRule rulesListValue : rulesList) {
                    if (rulesListValue == null) continue;
                    ActivatedRuleJsonMarshaller.getInstance().marshall(rulesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static WebACLJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new WebACLJsonMarshaller();
        }
        return instance;
    }
}

