/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.kms.model.GenerateDataKeyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Map;

public class GenerateDataKeyRequestMarshaller
implements Marshaller<Request<GenerateDataKeyRequest>, GenerateDataKeyRequest> {
    @Override
    public Request<GenerateDataKeyRequest> marshall(GenerateDataKeyRequest generateDataKeyRequest) {
        if (generateDataKeyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GenerateDataKeyRequest> request = new DefaultRequest<GenerateDataKeyRequest>(generateDataKeyRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.GenerateDataKey");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList grantTokensList;
            SdkInternalMap encryptionContextMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (generateDataKeyRequest.getKeyId() != null) {
                jsonWriter.key("KeyId").value(generateDataKeyRequest.getKeyId());
            }
            if (!(encryptionContextMap = (SdkInternalMap)generateDataKeyRequest.getEncryptionContext()).isEmpty() || !encryptionContextMap.isAutoConstruct()) {
                jsonWriter.key("EncryptionContext");
                jsonWriter.object();
                for (Map.Entry encryptionContextMapValue : encryptionContextMap.entrySet()) {
                    if (encryptionContextMapValue.getValue() == null) continue;
                    jsonWriter.key((String)encryptionContextMapValue.getKey());
                    jsonWriter.value(encryptionContextMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (generateDataKeyRequest.getNumberOfBytes() != null) {
                jsonWriter.key("NumberOfBytes").value(generateDataKeyRequest.getNumberOfBytes());
            }
            if (generateDataKeyRequest.getKeySpec() != null) {
                jsonWriter.key("KeySpec").value(generateDataKeyRequest.getKeySpec());
            }
            if (!(grantTokensList = (SdkInternalList)generateDataKeyRequest.getGrantTokens()).isEmpty() || !grantTokensList.isAutoConstruct()) {
                jsonWriter.key("GrantTokens");
                jsonWriter.array();
                for (String grantTokensListValue : grantTokensList) {
                    if (grantTokensListValue == null) continue;
                    jsonWriter.value(grantTokensListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

