/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.DurationRange;
import com.amazonaws.util.json.JSONWriter;

public class DurationRangeJsonMarshaller {
    private static DurationRangeJsonMarshaller instance;

    public void marshall(DurationRange durationRange, JSONWriter jsonWriter) {
        if (durationRange == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (durationRange.getMinimum() != null) {
                jsonWriter.key("minimum").value(durationRange.getMinimum());
            }
            if (durationRange.getMaximum() != null) {
                jsonWriter.key("maximum").value(durationRange.getMaximum());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DurationRangeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DurationRangeJsonMarshaller();
        }
        return instance;
    }
}

