/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AWSSessionCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.amazonaws.services.securitytoken.model.GetSessionTokenRequest;
import com.amazonaws.services.securitytoken.model.GetSessionTokenResult;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@ThreadSafe
public class STSSessionCredentialsProvider
implements AWSSessionCredentialsProvider {
    public static final int DEFAULT_DURATION_SECONDS = 3600;
    private static final int EXPIRY_TIME_MILLIS = 60000;
    private static final long NEW_SESSION_MAX_WAIT_SECONDS = 5L;
    private static final long ASYNC_REFRESH_EXPIRATION_IN_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private final AWSSecurityTokenService securityTokenService;
    private final Lock blockingNewSessionLock = new ReentrantLock();
    private final AtomicReference<SessionCredentialsHolder> sessionCredentials = new AtomicReference();
    private final AtomicReference<Thread> refreshThread = new AtomicReference();
    private final AtomicBoolean asyncRefreshing = new AtomicBoolean(false);

    public STSSessionCredentialsProvider(AWSCredentials longLivedCredentials) {
        this(longLivedCredentials, new ClientConfiguration());
    }

    public STSSessionCredentialsProvider(AWSCredentials longLivedCredentials, ClientConfiguration clientConfiguration) {
        this.securityTokenService = new AWSSecurityTokenServiceClient(longLivedCredentials, clientConfiguration);
    }

    public STSSessionCredentialsProvider(AWSCredentialsProvider longLivedCredentialsProvider) {
        this.securityTokenService = new AWSSecurityTokenServiceClient(longLivedCredentialsProvider);
    }

    public STSSessionCredentialsProvider(AWSCredentialsProvider longLivedCredentialsProvider, ClientConfiguration clientConfiguration) {
        this.securityTokenService = new AWSSecurityTokenServiceClient(longLivedCredentialsProvider, clientConfiguration);
    }

    public void setSTSClientEndpoint(String endpoint) {
        this.securityTokenService.setEndpoint(endpoint);
        this.sessionCredentials.set(null);
    }

    @Override
    public AWSSessionCredentials getCredentials() {
        SessionCredentialsHolder credsHolder = this.sessionCredentials.get();
        if (this.needsNewSession(credsHolder)) {
            this.blockingNewSession();
        } else if (this.shouldAsyncRefresh()) {
            this.asyncNewSession();
        }
        credsHolder = this.sessionCredentials.get();
        if (credsHolder != null && credsHolder.sessionCredentials != null) {
            return credsHolder.sessionCredentials;
        }
        throw new IllegalStateException("Session credentials should never be null.");
    }

    @Override
    public void refresh() {
        this.sessionCredentials.set(null);
        this.blockingNewSession();
    }

    private void newSession() {
        GetSessionTokenResult sessionTokenResult = this.securityTokenService.getSessionToken(new GetSessionTokenRequest().withDurationSeconds(3600));
        Credentials stsCredentials = sessionTokenResult.getCredentials();
        BasicSessionCredentials credentials = new BasicSessionCredentials(stsCredentials.getAccessKeyId(), stsCredentials.getSecretAccessKey(), stsCredentials.getSessionToken());
        SessionCredentialsHolder credsHolder = new SessionCredentialsHolder(credentials, stsCredentials.getExpiration());
        this.sessionCredentials.compareAndSet(this.sessionCredentials.get(), credsHolder);
    }

    private void handleWaitError(String error, Exception cause) {
        Thread newSessionThread = this.refreshThread.get();
        if (null != newSessionThread) {
            try {
                newSessionThread.interrupt();
            }
            catch (SecurityException ex) {
                // empty catch block
            }
        }
        throw new AmazonClientException(error, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockingNewSession() {
        try {
            this.blockingNewSessionLock.tryLock(5L, TimeUnit.SECONDS);
            try {
                if (!this.needsNewSession()) {
                    return;
                }
                this.newSession();
                return;
            }
            finally {
                this.blockingNewSessionLock.unlock();
            }
        }
        catch (InterruptedException ex) {
            this.handleWaitError("Interrupted waiting for new session credentials.", ex);
            this.newSession();
            return;
        }
    }

    private void asyncNewSession() {
        if (this.asyncRefreshing.compareAndSet(false, true)) {
            try {
                this.refreshThread.set(new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            STSSessionCredentialsProvider.this.newSession();
                        }
                        finally {
                            STSSessionCredentialsProvider.this.asyncRefreshing.set(false);
                        }
                    }
                });
                this.refreshThread.get().start();
            }
            catch (RuntimeException ex) {
                this.asyncRefreshing.set(false);
                throw ex;
            }
        }
    }

    private boolean shouldAsyncRefresh() {
        Date expiryTime = this.sessionCredentials.get().sessionCredentialsExpiration;
        if (expiryTime != null) {
            long timeRemaining = expiryTime.getTime() - System.currentTimeMillis();
            return timeRemaining < ASYNC_REFRESH_EXPIRATION_IN_MILLIS;
        }
        return false;
    }

    private static boolean expiring(Date expiry) {
        long timeRemaining = expiry.getTime() - System.currentTimeMillis();
        return timeRemaining < 60000L;
    }

    private boolean needsNewSession() {
        return this.needsNewSession(this.sessionCredentials.get());
    }

    private boolean needsNewSession(SessionCredentialsHolder credentialsHolder) {
        return credentialsHolder == null || STSSessionCredentialsProvider.expiring(credentialsHolder.sessionCredentialsExpiration);
    }

    private static final class SessionCredentialsHolder {
        private final AWSSessionCredentials sessionCredentials;
        private final Date sessionCredentialsExpiration;

        private SessionCredentialsHolder(AWSSessionCredentials sessionCredentials, Date sessionCredentialsExpiration) {
            this.sessionCredentials = sessionCredentials;
            this.sessionCredentialsExpiration = sessionCredentialsExpiration;
        }

        public int hashCode() {
            return this.sessionCredentials.hashCode();
        }

        public boolean equals(Object obj) {
            if (null == obj) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SessionCredentialsHolder other = (SessionCredentialsHolder)obj;
            return this.sessionCredentials == other.sessionCredentials || null != this.sessionCredentials && this.sessionCredentials.equals(other.sessionCredentials);
        }
    }
}

