/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.gamelift.model.FleetCapacity;
import com.amazonaws.services.gamelift.model.transform.EC2InstanceCountsJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class FleetCapacityJsonMarshaller {
    private static FleetCapacityJsonMarshaller instance;

    public void marshall(FleetCapacity fleetCapacity, JSONWriter jsonWriter) {
        if (fleetCapacity == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (fleetCapacity.getFleetId() != null) {
                jsonWriter.key("FleetId").value(fleetCapacity.getFleetId());
            }
            if (fleetCapacity.getInstanceType() != null) {
                jsonWriter.key("InstanceType").value(fleetCapacity.getInstanceType());
            }
            if (fleetCapacity.getInstanceCounts() != null) {
                jsonWriter.key("InstanceCounts");
                EC2InstanceCountsJsonMarshaller.getInstance().marshall(fleetCapacity.getInstanceCounts(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FleetCapacityJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FleetCapacityJsonMarshaller();
        }
        return instance;
    }
}

