/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elastictranscoder.model.TestRoleRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class TestRoleRequestMarshaller
implements Marshaller<Request<TestRoleRequest>, TestRoleRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<TestRoleRequest> marshall(TestRoleRequest testRoleRequest) {
        if (testRoleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<TestRoleRequest> request = new DefaultRequest<TestRoleRequest>(testRoleRequest, "AmazonElasticTranscoder");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2012-09-25/roleTests";
        request.setResourcePath(uriResourcePath);
        try {
            SdkInternalList topicsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (testRoleRequest.getRole() != null) {
                jsonWriter.key("Role").value(testRoleRequest.getRole());
            }
            if (testRoleRequest.getInputBucket() != null) {
                jsonWriter.key("InputBucket").value(testRoleRequest.getInputBucket());
            }
            if (testRoleRequest.getOutputBucket() != null) {
                jsonWriter.key("OutputBucket").value(testRoleRequest.getOutputBucket());
            }
            if (!(topicsList = (SdkInternalList)testRoleRequest.getTopics()).isEmpty() || !topicsList.isAutoConstruct()) {
                jsonWriter.key("Topics");
                jsonWriter.array();
                for (String topicsListValue : topicsList) {
                    if (topicsListValue == null) continue;
                    jsonWriter.value(topicsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

