/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ecs.model.VersionInfo;
import com.amazonaws.util.json.JSONWriter;

public class VersionInfoJsonMarshaller {
    private static VersionInfoJsonMarshaller instance;

    public void marshall(VersionInfo versionInfo, JSONWriter jsonWriter) {
        if (versionInfo == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (versionInfo.getAgentVersion() != null) {
                jsonWriter.key("agentVersion").value(versionInfo.getAgentVersion());
            }
            if (versionInfo.getAgentHash() != null) {
                jsonWriter.key("agentHash").value(versionInfo.getAgentHash());
            }
            if (versionInfo.getDockerVersion() != null) {
                jsonWriter.key("dockerVersion").value(versionInfo.getDockerVersion());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static VersionInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new VersionInfoJsonMarshaller();
        }
        return instance;
    }
}

