/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.Scope;
import com.amazonaws.util.json.JSONWriter;

public class ScopeJsonMarshaller {
    private static ScopeJsonMarshaller instance;

    public void marshall(Scope scope, JSONWriter jsonWriter) {
        if (scope == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            SdkInternalList complianceResourceTypesList = (SdkInternalList)scope.getComplianceResourceTypes();
            if (!complianceResourceTypesList.isEmpty() || !complianceResourceTypesList.isAutoConstruct()) {
                jsonWriter.key("ComplianceResourceTypes");
                jsonWriter.array();
                for (String complianceResourceTypesListValue : complianceResourceTypesList) {
                    if (complianceResourceTypesListValue == null) continue;
                    jsonWriter.value(complianceResourceTypesListValue);
                }
                jsonWriter.endArray();
            }
            if (scope.getTagKey() != null) {
                jsonWriter.key("TagKey").value(scope.getTagKey());
            }
            if (scope.getTagValue() != null) {
                jsonWriter.key("TagValue").value(scope.getTagValue());
            }
            if (scope.getComplianceResourceId() != null) {
                jsonWriter.key("ComplianceResourceId").value(scope.getComplianceResourceId());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ScopeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ScopeJsonMarshaller();
        }
        return instance;
    }
}

