/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.ListDeploymentsRequest;
import com.amazonaws.services.codedeploy.model.transform.TimeRangeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListDeploymentsRequestMarshaller
implements Marshaller<Request<ListDeploymentsRequest>, ListDeploymentsRequest> {
    @Override
    public Request<ListDeploymentsRequest> marshall(ListDeploymentsRequest listDeploymentsRequest) {
        if (listDeploymentsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListDeploymentsRequest> request = new DefaultRequest<ListDeploymentsRequest>(listDeploymentsRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.ListDeployments");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList includeOnlyStatusesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listDeploymentsRequest.getApplicationName() != null) {
                jsonWriter.key("applicationName").value(listDeploymentsRequest.getApplicationName());
            }
            if (listDeploymentsRequest.getDeploymentGroupName() != null) {
                jsonWriter.key("deploymentGroupName").value(listDeploymentsRequest.getDeploymentGroupName());
            }
            if (!(includeOnlyStatusesList = (SdkInternalList)listDeploymentsRequest.getIncludeOnlyStatuses()).isEmpty() || !includeOnlyStatusesList.isAutoConstruct()) {
                jsonWriter.key("includeOnlyStatuses");
                jsonWriter.array();
                for (String includeOnlyStatusesListValue : includeOnlyStatusesList) {
                    if (includeOnlyStatusesListValue == null) continue;
                    jsonWriter.value(includeOnlyStatusesListValue);
                }
                jsonWriter.endArray();
            }
            if (listDeploymentsRequest.getCreateTimeRange() != null) {
                jsonWriter.key("createTimeRange");
                TimeRangeJsonMarshaller.getInstance().marshall(listDeploymentsRequest.getCreateTimeRange(), jsonWriter);
            }
            if (listDeploymentsRequest.getNextToken() != null) {
                jsonWriter.key("nextToken").value(listDeploymentsRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

