/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elastictranscoder.model.Pipeline;
import com.amazonaws.services.elastictranscoder.model.transform.NotificationsJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.PipelineOutputConfigJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class PipelineJsonMarshaller {
    private static PipelineJsonMarshaller instance;

    public void marshall(Pipeline pipeline, JSONWriter jsonWriter) {
        if (pipeline == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (pipeline.getId() != null) {
                jsonWriter.key("Id").value(pipeline.getId());
            }
            if (pipeline.getArn() != null) {
                jsonWriter.key("Arn").value(pipeline.getArn());
            }
            if (pipeline.getName() != null) {
                jsonWriter.key("Name").value(pipeline.getName());
            }
            if (pipeline.getStatus() != null) {
                jsonWriter.key("Status").value(pipeline.getStatus());
            }
            if (pipeline.getInputBucket() != null) {
                jsonWriter.key("InputBucket").value(pipeline.getInputBucket());
            }
            if (pipeline.getOutputBucket() != null) {
                jsonWriter.key("OutputBucket").value(pipeline.getOutputBucket());
            }
            if (pipeline.getRole() != null) {
                jsonWriter.key("Role").value(pipeline.getRole());
            }
            if (pipeline.getAwsKmsKeyArn() != null) {
                jsonWriter.key("AwsKmsKeyArn").value(pipeline.getAwsKmsKeyArn());
            }
            if (pipeline.getNotifications() != null) {
                jsonWriter.key("Notifications");
                NotificationsJsonMarshaller.getInstance().marshall(pipeline.getNotifications(), jsonWriter);
            }
            if (pipeline.getContentConfig() != null) {
                jsonWriter.key("ContentConfig");
                PipelineOutputConfigJsonMarshaller.getInstance().marshall(pipeline.getContentConfig(), jsonWriter);
            }
            if (pipeline.getThumbnailConfig() != null) {
                jsonWriter.key("ThumbnailConfig");
                PipelineOutputConfigJsonMarshaller.getInstance().marshall(pipeline.getThumbnailConfig(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PipelineJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PipelineJsonMarshaller();
        }
        return instance;
    }
}

