/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.ModifyVpcEndpointRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ModifyVpcEndpointRequestMarshaller
implements Marshaller<Request<ModifyVpcEndpointRequest>, ModifyVpcEndpointRequest> {
    @Override
    public Request<ModifyVpcEndpointRequest> marshall(ModifyVpcEndpointRequest modifyVpcEndpointRequest) {
        if (modifyVpcEndpointRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyVpcEndpointRequest> request = new DefaultRequest<ModifyVpcEndpointRequest>(modifyVpcEndpointRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVpcEndpoint");
        request.addParameter("Version", "2015-10-01");
        if (modifyVpcEndpointRequest.getVpcEndpointId() != null) {
            request.addParameter("VpcEndpointId", StringUtils.fromString(modifyVpcEndpointRequest.getVpcEndpointId()));
        }
        if (modifyVpcEndpointRequest.isResetPolicy() != null) {
            request.addParameter("ResetPolicy", StringUtils.fromBoolean(modifyVpcEndpointRequest.isResetPolicy()));
        }
        if (modifyVpcEndpointRequest.getPolicyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString(modifyVpcEndpointRequest.getPolicyDocument()));
        }
        List<String> addRouteTableIdsList = modifyVpcEndpointRequest.getAddRouteTableIds();
        int addRouteTableIdsListIndex = 1;
        for (String addRouteTableIdsListValue : addRouteTableIdsList) {
            if (addRouteTableIdsListValue != null) {
                request.addParameter("AddRouteTableId." + addRouteTableIdsListIndex, StringUtils.fromString(addRouteTableIdsListValue));
            }
            ++addRouteTableIdsListIndex;
        }
        List<String> removeRouteTableIdsList = modifyVpcEndpointRequest.getRemoveRouteTableIds();
        int removeRouteTableIdsListIndex = 1;
        for (String removeRouteTableIdsListValue : removeRouteTableIdsList) {
            if (removeRouteTableIdsListValue != null) {
                request.addParameter("RemoveRouteTableId." + removeRouteTableIdsListIndex, StringUtils.fromString(removeRouteTableIdsListValue));
            }
            ++removeRouteTableIdsListIndex;
        }
        return request;
    }
}

