/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAttribute;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGeneratedKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBDocument;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIgnore;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIndexHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIndexRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTable;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBVersionAttribute;
import com.amazonaws.services.dynamodbv2.datamodeling.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.http.annotation.GuardedBy;

class DynamoDBReflector {
    private final Map<Class<?>, Collection<Method>> getterCache = new HashMap();
    private final Map<Class<?>, Method> primaryHashKeyGetterCache = new HashMap();
    private final Map<Class<?>, Method> primaryRangeKeyGetterCache = new HashMap();
    private final Map<Class<?>, List<Method>> primaryKeyGettersCache = new HashMap();
    private final Map<Method, Method> setterCache = new HashMap<Method, Method>();
    @GuardedBy(value="readWriteLockAttrName")
    private final Map<Method, String> attributeNameCache = new HashMap<Method, String>();
    private final Map<Method, Boolean> versionAttributeGetterCache = new HashMap<Method, Boolean>();
    private final Map<Method, Boolean> autoGeneratedKeyGetterCache = new HashMap<Method, Boolean>();
    private final ReentrantReadWriteLock readWriteLockAttrName = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLockAttrName = this.readWriteLockAttrName.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLockAttrName = this.readWriteLockAttrName.writeLock();

    DynamoDBReflector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Method> getRelevantGetters(Class<?> clazz) {
        Map<Class<?>, Collection<Method>> map = this.getterCache;
        synchronized (map) {
            if (!this.getterCache.containsKey(clazz)) {
                List<Method> relevantGetters = DynamoDBReflector.findRelevantGetters(clazz);
                this.getterCache.put(clazz, relevantGetters);
            }
            return this.getterCache.get(clazz);
        }
    }

    static List<Method> findRelevantGetters(Class<?> clazz) {
        LinkedList<Method> relevantGetters = new LinkedList<Method>();
        for (Method m : clazz.getMethods()) {
            if (!DynamoDBReflector.isRelevantGetter(m)) continue;
            relevantGetters.add(m);
        }
        return relevantGetters;
    }

    private static boolean isRelevantGetter(Method m) {
        return (m.getName().startsWith("get") || m.getName().startsWith("is")) && m.getParameterTypes().length == 0 && !m.isBridge() && !m.isSynthetic() && DynamoDBReflector.isDocumentType(m.getDeclaringClass()) && !ReflectionUtils.getterOrFieldHasAnnotation(m, DynamoDBIgnore.class);
    }

    private static boolean isDocumentType(Class<?> clazz) {
        return clazz.getAnnotation(DynamoDBTable.class) != null || clazz.getAnnotation(DynamoDBDocument.class) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Method getPrimaryRangeKeyGetter(Class<T> clazz) {
        Map<Class<?>, Method> map = this.primaryRangeKeyGetterCache;
        synchronized (map) {
            if (!this.primaryRangeKeyGetterCache.containsKey(clazz)) {
                Method rangeKeyMethod = null;
                for (Method method : this.getRelevantGetters(clazz)) {
                    if (method.getParameterTypes().length != 0 || !ReflectionUtils.getterOrFieldHasAnnotation(method, DynamoDBRangeKey.class)) continue;
                    rangeKeyMethod = method;
                    break;
                }
                this.primaryRangeKeyGetterCache.put(clazz, rangeKeyMethod);
            }
            return this.primaryRangeKeyGetterCache.get(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Collection<Method> getPrimaryKeyGetters(Class<T> clazz) {
        Map<Class<?>, List<Method>> map = this.primaryKeyGettersCache;
        synchronized (map) {
            if (!this.primaryKeyGettersCache.containsKey(clazz)) {
                LinkedList<Method> keyGetters = new LinkedList<Method>();
                for (Method getter : this.getRelevantGetters(clazz)) {
                    if (!ReflectionUtils.getterOrFieldHasAnnotation(getter, DynamoDBHashKey.class) && !ReflectionUtils.getterOrFieldHasAnnotation(getter, DynamoDBRangeKey.class)) continue;
                    keyGetters.add(getter);
                }
                this.primaryKeyGettersCache.put(clazz, keyGetters);
            }
            return this.primaryKeyGettersCache.get(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Method getPrimaryHashKeyGetter(Class<T> clazz) {
        Method hashKeyMethod;
        Map<Class<?>, Method> map = this.primaryHashKeyGetterCache;
        synchronized (map) {
            if (!this.primaryHashKeyGetterCache.containsKey(clazz)) {
                for (Method method : this.getRelevantGetters(clazz)) {
                    if (method.getParameterTypes().length != 0 || !ReflectionUtils.getterOrFieldHasAnnotation(method, DynamoDBHashKey.class)) continue;
                    this.primaryHashKeyGetterCache.put(clazz, method);
                    break;
                }
            }
            hashKeyMethod = this.primaryHashKeyGetterCache.get(clazz);
        }
        if (hashKeyMethod == null) {
            throw new DynamoDBMappingException("Public, zero-parameter hash key property must be annotated with " + DynamoDBHashKey.class);
        }
        return hashKeyMethod;
    }

    <T> DynamoDBTable getTable(Class<T> clazz) {
        DynamoDBTable table = clazz.getAnnotation(DynamoDBTable.class);
        if (table == null) {
            throw new DynamoDBMappingException("Class " + clazz + " must be annotated with " + DynamoDBTable.class);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getAttributeName(Method getter) {
        String attributeName;
        this.readLockAttrName.lock();
        try {
            attributeName = this.attributeNameCache.get(getter);
        }
        finally {
            this.readLockAttrName.unlock();
        }
        if (attributeName != null) {
            return attributeName;
        }
        DynamoDBHashKey hashKeyAnnotation = ReflectionUtils.getAnnotationFromGetterOrField(getter, DynamoDBHashKey.class);
        if (hashKeyAnnotation != null && (attributeName = hashKeyAnnotation.attributeName()) != null && attributeName.length() > 0) {
            return this.cacheAttributeName(getter, attributeName);
        }
        DynamoDBIndexHashKey indexHashKey = ReflectionUtils.getAnnotationFromGetterOrField(getter, DynamoDBIndexHashKey.class);
        if (indexHashKey != null && (attributeName = indexHashKey.attributeName()) != null && attributeName.length() > 0) {
            return this.cacheAttributeName(getter, attributeName);
        }
        DynamoDBRangeKey rangeKey = ReflectionUtils.getAnnotationFromGetterOrField(getter, DynamoDBRangeKey.class);
        if (rangeKey != null && (attributeName = rangeKey.attributeName()) != null && attributeName.length() > 0) {
            return this.cacheAttributeName(getter, attributeName);
        }
        DynamoDBIndexRangeKey indexRangeKey = ReflectionUtils.getAnnotationFromGetterOrField(getter, DynamoDBIndexRangeKey.class);
        if (indexRangeKey != null && (attributeName = indexRangeKey.attributeName()) != null && attributeName.length() > 0) {
            return this.cacheAttributeName(getter, attributeName);
        }
        DynamoDBAttribute attribute = ReflectionUtils.getAnnotationFromGetterOrField(getter, DynamoDBAttribute.class);
        if (attribute != null && (attributeName = attribute.attributeName()) != null && attributeName.length() > 0) {
            return this.cacheAttributeName(getter, attributeName);
        }
        DynamoDBVersionAttribute version = ReflectionUtils.getAnnotationFromGetterOrField(getter, DynamoDBVersionAttribute.class);
        if (version != null && (attributeName = version.attributeName()) != null && attributeName.length() > 0) {
            return this.cacheAttributeName(getter, attributeName);
        }
        attributeName = ReflectionUtils.getFieldNameByGetter(getter, true);
        return this.cacheAttributeName(getter, attributeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cacheAttributeName(Method getter, String attributeName) {
        this.writeLockAttrName.lock();
        try {
            this.attributeNameCache.put(getter, attributeName);
        }
        finally {
            this.writeLockAttrName.unlock();
        }
        return attributeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Method getSetter(Method getter) {
        Map<Method, Method> map = this.setterCache;
        synchronized (map) {
            if (!this.setterCache.containsKey(getter)) {
                String fieldName = ReflectionUtils.getFieldNameByGetter(getter, false);
                String setterName = "set" + fieldName;
                Method setter = null;
                try {
                    setter = getter.getDeclaringClass().getMethod(setterName, getter.getReturnType());
                }
                catch (NoSuchMethodException e) {
                    throw new DynamoDBMappingException("Expected a public, one-argument method called " + setterName + " on class " + getter.getDeclaringClass(), e);
                }
                catch (SecurityException e) {
                    throw new DynamoDBMappingException("No access to public, one-argument method called " + setterName + " on class " + getter.getDeclaringClass(), e);
                }
                this.setterCache.put(getter, setter);
            }
            return this.setterCache.get(getter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isVersionAttributeGetter(Method getter) {
        Map<Method, Boolean> map = this.versionAttributeGetterCache;
        synchronized (map) {
            if (!this.versionAttributeGetterCache.containsKey(getter)) {
                this.versionAttributeGetterCache.put(getter, getter.getName().startsWith("get") && getter.getParameterTypes().length == 0 && ReflectionUtils.getterOrFieldHasAnnotation(getter, DynamoDBVersionAttribute.class));
            }
            return this.versionAttributeGetterCache.get(getter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAssignableKey(Method getter) {
        Map<Method, Boolean> map = this.autoGeneratedKeyGetterCache;
        synchronized (map) {
            if (!this.autoGeneratedKeyGetterCache.containsKey(getter)) {
                this.autoGeneratedKeyGetterCache.put(getter, ReflectionUtils.getterOrFieldHasAnnotation(getter, DynamoDBAutoGeneratedKey.class) && (ReflectionUtils.getterOrFieldHasAnnotation(getter, DynamoDBHashKey.class) || ReflectionUtils.getterOrFieldHasAnnotation(getter, DynamoDBRangeKey.class) || ReflectionUtils.getterOrFieldHasAnnotation(getter, DynamoDBIndexHashKey.class) || ReflectionUtils.getterOrFieldHasAnnotation(getter, DynamoDBIndexRangeKey.class)));
            }
            return this.autoGeneratedKeyGetterCache.get(getter);
        }
    }

    String getPrimaryHashKeyName(Class<?> clazz) {
        return this.getAttributeName(this.getPrimaryHashKeyGetter(clazz));
    }

    String getPrimaryRangeKeyName(Class<?> clazz) {
        Method primaryRangeKeyGetter = this.getPrimaryHashKeyGetter(clazz);
        return primaryRangeKeyGetter == null ? null : this.getAttributeName(this.getPrimaryRangeKeyGetter(clazz));
    }

    boolean hasPrimaryRangeKey(Class<?> clazz) {
        return this.getPrimaryRangeKeyGetter(clazz) != null;
    }
}

