/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import java.math.BigInteger;
import java.util.UUID;

final class DynamoDBAutoGeneratorRegistry {
    private static final DynamoDBAutoGeneratorRegistry INSTANCE = new DynamoDBAutoGeneratorRegistry();

    DynamoDBAutoGeneratorRegistry() {
    }

    static final DynamoDBAutoGeneratorRegistry instance() {
        return INSTANCE;
    }

    final Generator<Object> generatorOf(Generators type, Class<?> clazz) {
        Generator<Object> result = type.generatorOf(clazz);
        return result;
    }

    static final class ShortVersionGenerator
    extends AbstractVersionGenerator<Short> {
        private static final Generator<Short> INSTANCE = new ShortVersionGenerator();

        ShortVersionGenerator() {
        }

        @Override
        public final Short generate(Short currentValue) {
            if (currentValue == null) {
                return (short)1;
            }
            return (short)(currentValue + 1);
        }
    }

    static final class LongVersionGenerator
    extends AbstractVersionGenerator<Long> {
        private static final Generator<Long> INSTANCE = new LongVersionGenerator();

        LongVersionGenerator() {
        }

        @Override
        public final Long generate(Long currentValue) {
            if (currentValue == null) {
                return 1L;
            }
            return currentValue + 1L;
        }
    }

    static final class IntegerVersionGenerator
    extends AbstractVersionGenerator<Integer> {
        private static final Generator<Integer> INSTANCE = new IntegerVersionGenerator();

        IntegerVersionGenerator() {
        }

        @Override
        public final Integer generate(Integer currentValue) {
            if (currentValue == null) {
                return 1;
            }
            return currentValue + 1;
        }
    }

    static final class ByteVersionGenerator
    extends AbstractVersionGenerator<Byte> {
        private static final Generator<Byte> INSTANCE = new ByteVersionGenerator();

        ByteVersionGenerator() {
        }

        @Override
        public final Byte generate(Byte currentValue) {
            if (currentValue == null) {
                return (byte)1;
            }
            return (byte)((currentValue + 1) % 127);
        }
    }

    static final class BigIntegerVersionGenerator
    extends AbstractVersionGenerator<BigInteger> {
        private static final Generator<BigInteger> INSTANCE = new BigIntegerVersionGenerator();

        BigIntegerVersionGenerator() {
        }

        @Override
        public final BigInteger generate(BigInteger currentValue) {
            if (currentValue == null) {
                return BigInteger.ONE;
            }
            return currentValue.add(BigInteger.ONE);
        }
    }

    static final class NeverVersionGenerator
    extends AbstractVersionGenerator<Object> {
        private static final Generator<Object> INSTANCE = new NeverVersionGenerator();

        NeverVersionGenerator() {
        }

        @Override
        public final Object generate(Object currentValue) {
            throw new DynamoDBMappingException("Unsupported type for @DynamoDBVersionAttribute; only BigInteger, Byte, Integer or Long allowed");
        }
    }

    static abstract class AbstractVersionGenerator<T>
    implements Generator<T> {
        AbstractVersionGenerator() {
        }

        @Override
        public final boolean canGenerate(T currentValue) {
            return true;
        }
    }

    static final class UuidStringKeyGenerator
    extends AbstractKeyGenerator<String> {
        private static final Generator<String> INSTANCE = new UuidStringKeyGenerator();

        UuidStringKeyGenerator() {
        }

        @Override
        public final String generate(String currentValue) {
            return UUID.randomUUID().toString();
        }
    }

    static final class NeverKeyGenerator
    extends AbstractKeyGenerator<Object> {
        private static final Generator<Object> INSTANCE = new NeverKeyGenerator();

        NeverKeyGenerator() {
        }

        @Override
        public final Object generate(Object currentValue) {
            throw new DynamoDBMappingException("Unsupported type for @DynamoDBAutoGeneratedKey; only String allowed");
        }
    }

    static abstract class AbstractKeyGenerator<T>
    implements Generator<T> {
        AbstractKeyGenerator() {
        }

        @Override
        public final boolean canGenerate(T currentValue) {
            return currentValue == null;
        }
    }

    static final class NeverGenerator
    implements Generator<Object> {
        private static final Generator<Object> INSTANCE = new NeverGenerator();

        NeverGenerator() {
        }

        @Override
        public final boolean canGenerate(Object currentValue) {
            return false;
        }

        @Override
        public final Object generate(Object currentValue) {
            throw new DynamoDBMappingException("generate not supported for " + this.getClass().getName());
        }
    }

    static interface Generator<T> {
        public boolean canGenerate(T var1);

        public T generate(T var1);
    }

    static interface GeneratorFactory {
        public Generator<? extends Object> generatorOf(Class<?> var1);
    }

    static enum Generators implements GeneratorFactory
    {
        NEVER{

            @Override
            public final Generator<? extends Object> generatorOf(Class<?> clazz) {
                return NeverGenerator.INSTANCE;
            }
        }
        ,
        KEY{

            @Override
            public final Generator<? extends Object> generatorOf(Class<?> clazz) {
                if (String.class.isAssignableFrom(clazz)) {
                    return UuidStringKeyGenerator.INSTANCE;
                }
                return NeverKeyGenerator.INSTANCE;
            }
        }
        ,
        VERSION{

            @Override
            public final Generator<? extends Object> generatorOf(Class<?> clazz) {
                if (BigInteger.class.isAssignableFrom(clazz)) {
                    return BigIntegerVersionGenerator.INSTANCE;
                }
                if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz)) {
                    return ByteVersionGenerator.INSTANCE;
                }
                if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
                    return IntegerVersionGenerator.INSTANCE;
                }
                if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
                    return LongVersionGenerator.INSTANCE;
                }
                return NeverVersionGenerator.INSTANCE;
            }
        };

    }
}

