/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsAsync;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsClient;
import com.amazonaws.services.dynamodbv2.model.DescribeStreamRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeStreamResult;
import com.amazonaws.services.dynamodbv2.model.GetRecordsRequest;
import com.amazonaws.services.dynamodbv2.model.GetRecordsResult;
import com.amazonaws.services.dynamodbv2.model.GetShardIteratorRequest;
import com.amazonaws.services.dynamodbv2.model.GetShardIteratorResult;
import com.amazonaws.services.dynamodbv2.model.ListStreamsRequest;
import com.amazonaws.services.dynamodbv2.model.ListStreamsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonDynamoDBStreamsAsyncClient
extends AmazonDynamoDBStreamsClient
implements AmazonDynamoDBStreamsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonDynamoDBStreamsAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonDynamoDBStreamsAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonDynamoDBStreamsAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonDynamoDBStreamsAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AmazonDynamoDBStreamsAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonDynamoDBStreamsAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonDynamoDBStreamsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonDynamoDBStreamsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AmazonDynamoDBStreamsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(DescribeStreamRequest request) {
        return this.describeStreamAsync(request, null);
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(final DescribeStreamRequest request, final AsyncHandler<DescribeStreamRequest, DescribeStreamResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeStreamResult>(){

            @Override
            public DescribeStreamResult call() throws Exception {
                DescribeStreamResult result;
                try {
                    result = AmazonDynamoDBStreamsAsyncClient.this.describeStream(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRecordsResult> getRecordsAsync(GetRecordsRequest request) {
        return this.getRecordsAsync(request, null);
    }

    @Override
    public Future<GetRecordsResult> getRecordsAsync(final GetRecordsRequest request, final AsyncHandler<GetRecordsRequest, GetRecordsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetRecordsResult>(){

            @Override
            public GetRecordsResult call() throws Exception {
                GetRecordsResult result;
                try {
                    result = AmazonDynamoDBStreamsAsyncClient.this.getRecords(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetShardIteratorResult> getShardIteratorAsync(GetShardIteratorRequest request) {
        return this.getShardIteratorAsync(request, null);
    }

    @Override
    public Future<GetShardIteratorResult> getShardIteratorAsync(final GetShardIteratorRequest request, final AsyncHandler<GetShardIteratorRequest, GetShardIteratorResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetShardIteratorResult>(){

            @Override
            public GetShardIteratorResult call() throws Exception {
                GetShardIteratorResult result;
                try {
                    result = AmazonDynamoDBStreamsAsyncClient.this.getShardIterator(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(ListStreamsRequest request) {
        return this.listStreamsAsync(request, null);
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(final ListStreamsRequest request, final AsyncHandler<ListStreamsRequest, ListStreamsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListStreamsResult>(){

            @Override
            public ListStreamsResult call() throws Exception {
                ListStreamsResult result;
                try {
                    result = AmazonDynamoDBStreamsAsyncClient.this.listStreams(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

