/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.datapipeline.model.Field;
import com.amazonaws.services.datapipeline.model.PipelineObject;
import com.amazonaws.services.datapipeline.model.transform.FieldJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class PipelineObjectJsonMarshaller {
    private static PipelineObjectJsonMarshaller instance;

    public void marshall(PipelineObject pipelineObject, JSONWriter jsonWriter) {
        if (pipelineObject == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList fieldsList;
            jsonWriter.object();
            if (pipelineObject.getId() != null) {
                jsonWriter.key("id").value(pipelineObject.getId());
            }
            if (pipelineObject.getName() != null) {
                jsonWriter.key("name").value(pipelineObject.getName());
            }
            if (!(fieldsList = (SdkInternalList)pipelineObject.getFields()).isEmpty() || !fieldsList.isAutoConstruct()) {
                jsonWriter.key("fields");
                jsonWriter.array();
                for (Field fieldsListValue : fieldsList) {
                    if (fieldsListValue == null) continue;
                    FieldJsonMarshaller.getInstance().marshall(fieldsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PipelineObjectJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PipelineObjectJsonMarshaller();
        }
        return instance;
    }
}

