/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.datapipeline.model.Operator;
import com.amazonaws.util.json.JSONWriter;

public class OperatorJsonMarshaller {
    private static OperatorJsonMarshaller instance;

    public void marshall(Operator operator, JSONWriter jsonWriter) {
        if (operator == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList valuesList;
            jsonWriter.object();
            if (operator.getType() != null) {
                jsonWriter.key("type").value(operator.getType());
            }
            if (!(valuesList = (SdkInternalList)operator.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                jsonWriter.key("values");
                jsonWriter.array();
                for (String valuesListValue : valuesList) {
                    if (valuesListValue == null) continue;
                    jsonWriter.value(valuesListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static OperatorJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new OperatorJsonMarshaller();
        }
        return instance;
    }
}

