/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitosync.model.DescribeDatasetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DescribeDatasetRequestMarshaller
implements Marshaller<Request<DescribeDatasetRequest>, DescribeDatasetRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";

    @Override
    public Request<DescribeDatasetRequest> marshall(DescribeDatasetRequest describeDatasetRequest) {
        if (describeDatasetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeDatasetRequest> request = new DefaultRequest<DescribeDatasetRequest>(describeDatasetRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", describeDatasetRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString(describeDatasetRequest.getIdentityPoolId()));
        uriResourcePath = uriResourcePath.replace("{IdentityId}", describeDatasetRequest.getIdentityId() == null ? "" : StringUtils.fromString(describeDatasetRequest.getIdentityId()));
        uriResourcePath = uriResourcePath.replace("{DatasetName}", describeDatasetRequest.getDatasetName() == null ? "" : StringUtils.fromString(describeDatasetRequest.getDatasetName()));
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

