/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetApiKeysRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetApiKeysRequestMarshaller
implements Marshaller<Request<GetApiKeysRequest>, GetApiKeysRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<GetApiKeysRequest> marshall(GetApiKeysRequest getApiKeysRequest) {
        String limit;
        String position;
        if (getApiKeysRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetApiKeysRequest> request = new DefaultRequest<GetApiKeysRequest>(getApiKeysRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/apikeys";
        request.setResourcePath(uriResourcePath);
        String string = position = getApiKeysRequest.getPosition() == null ? null : StringUtils.fromString(getApiKeysRequest.getPosition());
        if (position != null) {
            request.addParameter("position", position);
        }
        String string2 = limit = getApiKeysRequest.getLimit() == null ? null : StringUtils.fromInteger(getApiKeysRequest.getLimit());
        if (limit != null) {
            request.addParameter("limit", limit);
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

