/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeWorkspaceBundlesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<String> bundleIds;
    private String owner;
    private String nextToken;

    public List<String> getBundleIds() {
        if (this.bundleIds == null) {
            this.bundleIds = new ListWithAutoConstructFlag();
            this.bundleIds.setAutoConstruct(true);
        }
        return this.bundleIds;
    }

    public void setBundleIds(Collection<String> bundleIds) {
        if (bundleIds == null) {
            this.bundleIds = null;
            return;
        }
        ListWithAutoConstructFlag bundleIdsCopy = new ListWithAutoConstructFlag(bundleIds.size());
        bundleIdsCopy.addAll(bundleIds);
        this.bundleIds = bundleIdsCopy;
    }

    public DescribeWorkspaceBundlesRequest withBundleIds(String ... bundleIds) {
        if (this.getBundleIds() == null) {
            this.setBundleIds(new ArrayList<String>(bundleIds.length));
        }
        for (String value : bundleIds) {
            this.getBundleIds().add(value);
        }
        return this;
    }

    public DescribeWorkspaceBundlesRequest withBundleIds(Collection<String> bundleIds) {
        if (bundleIds == null) {
            this.bundleIds = null;
        } else {
            ListWithAutoConstructFlag bundleIdsCopy = new ListWithAutoConstructFlag(bundleIds.size());
            bundleIdsCopy.addAll(bundleIds);
            this.bundleIds = bundleIdsCopy;
        }
        return this;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public DescribeWorkspaceBundlesRequest withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeWorkspaceBundlesRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBundleIds() != null) {
            sb.append("BundleIds: " + this.getBundleIds() + ",");
        }
        if (this.getOwner() != null) {
            sb.append("Owner: " + this.getOwner() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBundleIds() == null ? 0 : this.getBundleIds().hashCode());
        hashCode = 31 * hashCode + (this.getOwner() == null ? 0 : this.getOwner().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceBundlesRequest)) {
            return false;
        }
        DescribeWorkspaceBundlesRequest other = (DescribeWorkspaceBundlesRequest)obj;
        if (other.getBundleIds() == null ^ this.getBundleIds() == null) {
            return false;
        }
        if (other.getBundleIds() != null && !other.getBundleIds().equals(this.getBundleIds())) {
            return false;
        }
        if (other.getOwner() == null ^ this.getOwner() == null) {
            return false;
        }
        if (other.getOwner() != null && !other.getOwner().equals(this.getOwner())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    @Override
    public DescribeWorkspaceBundlesRequest clone() {
        return (DescribeWorkspaceBundlesRequest)super.clone();
    }
}

