/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.devicefarm.AWSDeviceFarm;
import com.amazonaws.services.devicefarm.model.ArgumentException;
import com.amazonaws.services.devicefarm.model.CreateDevicePoolRequest;
import com.amazonaws.services.devicefarm.model.CreateDevicePoolResult;
import com.amazonaws.services.devicefarm.model.CreateProjectRequest;
import com.amazonaws.services.devicefarm.model.CreateProjectResult;
import com.amazonaws.services.devicefarm.model.CreateUploadRequest;
import com.amazonaws.services.devicefarm.model.CreateUploadResult;
import com.amazonaws.services.devicefarm.model.GetDevicePoolCompatibilityRequest;
import com.amazonaws.services.devicefarm.model.GetDevicePoolCompatibilityResult;
import com.amazonaws.services.devicefarm.model.GetDevicePoolRequest;
import com.amazonaws.services.devicefarm.model.GetDevicePoolResult;
import com.amazonaws.services.devicefarm.model.GetDeviceRequest;
import com.amazonaws.services.devicefarm.model.GetDeviceResult;
import com.amazonaws.services.devicefarm.model.GetJobRequest;
import com.amazonaws.services.devicefarm.model.GetJobResult;
import com.amazonaws.services.devicefarm.model.GetProjectRequest;
import com.amazonaws.services.devicefarm.model.GetProjectResult;
import com.amazonaws.services.devicefarm.model.GetRunRequest;
import com.amazonaws.services.devicefarm.model.GetRunResult;
import com.amazonaws.services.devicefarm.model.GetSuiteRequest;
import com.amazonaws.services.devicefarm.model.GetSuiteResult;
import com.amazonaws.services.devicefarm.model.GetTestRequest;
import com.amazonaws.services.devicefarm.model.GetTestResult;
import com.amazonaws.services.devicefarm.model.GetUploadRequest;
import com.amazonaws.services.devicefarm.model.GetUploadResult;
import com.amazonaws.services.devicefarm.model.IdempotencyException;
import com.amazonaws.services.devicefarm.model.LimitExceededException;
import com.amazonaws.services.devicefarm.model.ListArtifactsRequest;
import com.amazonaws.services.devicefarm.model.ListArtifactsResult;
import com.amazonaws.services.devicefarm.model.ListDevicePoolsRequest;
import com.amazonaws.services.devicefarm.model.ListDevicePoolsResult;
import com.amazonaws.services.devicefarm.model.ListDevicesRequest;
import com.amazonaws.services.devicefarm.model.ListDevicesResult;
import com.amazonaws.services.devicefarm.model.ListJobsRequest;
import com.amazonaws.services.devicefarm.model.ListJobsResult;
import com.amazonaws.services.devicefarm.model.ListProjectsRequest;
import com.amazonaws.services.devicefarm.model.ListProjectsResult;
import com.amazonaws.services.devicefarm.model.ListRunsRequest;
import com.amazonaws.services.devicefarm.model.ListRunsResult;
import com.amazonaws.services.devicefarm.model.ListSamplesRequest;
import com.amazonaws.services.devicefarm.model.ListSamplesResult;
import com.amazonaws.services.devicefarm.model.ListSuitesRequest;
import com.amazonaws.services.devicefarm.model.ListSuitesResult;
import com.amazonaws.services.devicefarm.model.ListTestsRequest;
import com.amazonaws.services.devicefarm.model.ListTestsResult;
import com.amazonaws.services.devicefarm.model.ListUniqueProblemsRequest;
import com.amazonaws.services.devicefarm.model.ListUniqueProblemsResult;
import com.amazonaws.services.devicefarm.model.ListUploadsRequest;
import com.amazonaws.services.devicefarm.model.ListUploadsResult;
import com.amazonaws.services.devicefarm.model.NotFoundException;
import com.amazonaws.services.devicefarm.model.ScheduleRunRequest;
import com.amazonaws.services.devicefarm.model.ScheduleRunResult;
import com.amazonaws.services.devicefarm.model.ServiceAccountException;
import com.amazonaws.services.devicefarm.model.transform.CreateDevicePoolRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.CreateDevicePoolResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.CreateProjectRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.CreateProjectResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.CreateUploadRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.CreateUploadResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.GetDevicePoolCompatibilityRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.GetDevicePoolCompatibilityResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.GetDevicePoolRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.GetDevicePoolResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.GetDeviceRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.GetDeviceResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.GetJobRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.GetJobResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.GetProjectRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.GetProjectResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.GetRunRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.GetRunResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.GetSuiteRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.GetSuiteResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.GetTestRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.GetTestResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.GetUploadRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.GetUploadResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListArtifactsRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListArtifactsResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListDevicePoolsRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListDevicePoolsResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListDevicesRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListDevicesResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListJobsRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListJobsResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListProjectsRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListProjectsResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListRunsRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListRunsResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListSamplesRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListSamplesResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListSuitesRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListSuitesResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListTestsRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListTestsResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListUniqueProblemsRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListUniqueProblemsResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListUploadsRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.ListUploadsResultJsonUnmarshaller;
import com.amazonaws.services.devicefarm.model.transform.ScheduleRunRequestMarshaller;
import com.amazonaws.services.devicefarm.model.transform.ScheduleRunResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AWSDeviceFarmClient
extends AmazonWebServiceClient
implements AWSDeviceFarm {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSDeviceFarm.class);
    protected List<JsonErrorUnmarshallerV2> jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshallerV2>();

    public AWSDeviceFarmClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AWSDeviceFarmClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSDeviceFarmClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AWSDeviceFarmClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSDeviceFarmClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AWSDeviceFarmClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSDeviceFarmClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AWSDeviceFarmClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ServiceAccountException.class, "ServiceAccountException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ArgumentException.class, "ArgumentException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(NotFoundException.class, "NotFoundException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(IdempotencyException.class, "IdempotencyException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(LimitExceededException.class, "LimitExceededException"));
        this.jsonErrorUnmarshallers.add(JsonErrorUnmarshallerV2.DEFAULT_UNMARSHALLER);
        this.setEndpoint("https://devicefarm.us-west-2.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/devicefarm/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/devicefarm/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration orig) {
        ClientConfiguration config = orig;
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDevicePoolResult createDevicePool(CreateDevicePoolRequest createDevicePoolRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDevicePoolRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDevicePoolRequest> request = null;
        Response<CreateDevicePoolResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDevicePoolRequestMarshaller().marshall(createDevicePoolRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new CreateDevicePoolResultJsonUnmarshaller(), executionContext);
            CreateDevicePoolResult createDevicePoolResult = response.getAwsResponse();
            return createDevicePoolResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateProjectResult createProject(CreateProjectRequest createProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateProjectRequest> request = null;
        Response<CreateProjectResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateProjectRequestMarshaller().marshall(createProjectRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new CreateProjectResultJsonUnmarshaller(), executionContext);
            CreateProjectResult createProjectResult = response.getAwsResponse();
            return createProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateUploadResult createUpload(CreateUploadRequest createUploadRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateUploadRequest> request = null;
        Response<CreateUploadResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateUploadRequestMarshaller().marshall(createUploadRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new CreateUploadResultJsonUnmarshaller(), executionContext);
            CreateUploadResult createUploadResult = response.getAwsResponse();
            return createUploadResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDeviceResult getDevice(GetDeviceRequest getDeviceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDeviceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDeviceRequest> request = null;
        Response<GetDeviceResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDeviceRequestMarshaller().marshall(getDeviceRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new GetDeviceResultJsonUnmarshaller(), executionContext);
            GetDeviceResult getDeviceResult = response.getAwsResponse();
            return getDeviceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDevicePoolResult getDevicePool(GetDevicePoolRequest getDevicePoolRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDevicePoolRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDevicePoolRequest> request = null;
        Response<GetDevicePoolResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDevicePoolRequestMarshaller().marshall(getDevicePoolRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new GetDevicePoolResultJsonUnmarshaller(), executionContext);
            GetDevicePoolResult getDevicePoolResult = response.getAwsResponse();
            return getDevicePoolResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDevicePoolCompatibilityResult getDevicePoolCompatibility(GetDevicePoolCompatibilityRequest getDevicePoolCompatibilityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDevicePoolCompatibilityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDevicePoolCompatibilityRequest> request = null;
        Response<GetDevicePoolCompatibilityResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDevicePoolCompatibilityRequestMarshaller().marshall(getDevicePoolCompatibilityRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new GetDevicePoolCompatibilityResultJsonUnmarshaller(), executionContext);
            GetDevicePoolCompatibilityResult getDevicePoolCompatibilityResult = response.getAwsResponse();
            return getDevicePoolCompatibilityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetJobResult getJob(GetJobRequest getJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetJobRequest> request = null;
        Response<GetJobResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetJobRequestMarshaller().marshall(getJobRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new GetJobResultJsonUnmarshaller(), executionContext);
            GetJobResult getJobResult = response.getAwsResponse();
            return getJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetProjectResult getProject(GetProjectRequest getProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetProjectRequest> request = null;
        Response<GetProjectResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetProjectRequestMarshaller().marshall(getProjectRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new GetProjectResultJsonUnmarshaller(), executionContext);
            GetProjectResult getProjectResult = response.getAwsResponse();
            return getProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRunResult getRun(GetRunRequest getRunRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRunRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRunRequest> request = null;
        Response<GetRunResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRunRequestMarshaller().marshall(getRunRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new GetRunResultJsonUnmarshaller(), executionContext);
            GetRunResult getRunResult = response.getAwsResponse();
            return getRunResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSuiteResult getSuite(GetSuiteRequest getSuiteRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSuiteRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSuiteRequest> request = null;
        Response<GetSuiteResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSuiteRequestMarshaller().marshall(getSuiteRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new GetSuiteResultJsonUnmarshaller(), executionContext);
            GetSuiteResult getSuiteResult = response.getAwsResponse();
            return getSuiteResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTestResult getTest(GetTestRequest getTestRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTestRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTestRequest> request = null;
        Response<GetTestResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTestRequestMarshaller().marshall(getTestRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new GetTestResultJsonUnmarshaller(), executionContext);
            GetTestResult getTestResult = response.getAwsResponse();
            return getTestResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetUploadResult getUpload(GetUploadRequest getUploadRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetUploadRequest> request = null;
        Response<GetUploadResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetUploadRequestMarshaller().marshall(getUploadRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new GetUploadResultJsonUnmarshaller(), executionContext);
            GetUploadResult getUploadResult = response.getAwsResponse();
            return getUploadResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListArtifactsResult listArtifacts(ListArtifactsRequest listArtifactsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listArtifactsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListArtifactsRequest> request = null;
        Response<ListArtifactsResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListArtifactsRequestMarshaller().marshall(listArtifactsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ListArtifactsResultJsonUnmarshaller(), executionContext);
            ListArtifactsResult listArtifactsResult = response.getAwsResponse();
            return listArtifactsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDevicePoolsResult listDevicePools(ListDevicePoolsRequest listDevicePoolsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDevicePoolsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDevicePoolsRequest> request = null;
        Response<ListDevicePoolsResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDevicePoolsRequestMarshaller().marshall(listDevicePoolsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ListDevicePoolsResultJsonUnmarshaller(), executionContext);
            ListDevicePoolsResult listDevicePoolsResult = response.getAwsResponse();
            return listDevicePoolsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDevicesResult listDevices(ListDevicesRequest listDevicesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDevicesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDevicesRequest> request = null;
        Response<ListDevicesResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDevicesRequestMarshaller().marshall(listDevicesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ListDevicesResultJsonUnmarshaller(), executionContext);
            ListDevicesResult listDevicesResult = response.getAwsResponse();
            return listDevicesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJobsResult listJobs(ListJobsRequest listJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJobsRequest> request = null;
        Response<ListJobsResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJobsRequestMarshaller().marshall(listJobsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ListJobsResultJsonUnmarshaller(), executionContext);
            ListJobsResult listJobsResult = response.getAwsResponse();
            return listJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListProjectsResult listProjects(ListProjectsRequest listProjectsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProjectsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProjectsRequest> request = null;
        Response<ListProjectsResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProjectsRequestMarshaller().marshall(listProjectsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ListProjectsResultJsonUnmarshaller(), executionContext);
            ListProjectsResult listProjectsResult = response.getAwsResponse();
            return listProjectsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRunsResult listRuns(ListRunsRequest listRunsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRunsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRunsRequest> request = null;
        Response<ListRunsResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRunsRequestMarshaller().marshall(listRunsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ListRunsResultJsonUnmarshaller(), executionContext);
            ListRunsResult listRunsResult = response.getAwsResponse();
            return listRunsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSamplesResult listSamples(ListSamplesRequest listSamplesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSamplesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSamplesRequest> request = null;
        Response<ListSamplesResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSamplesRequestMarshaller().marshall(listSamplesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ListSamplesResultJsonUnmarshaller(), executionContext);
            ListSamplesResult listSamplesResult = response.getAwsResponse();
            return listSamplesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSuitesResult listSuites(ListSuitesRequest listSuitesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSuitesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSuitesRequest> request = null;
        Response<ListSuitesResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSuitesRequestMarshaller().marshall(listSuitesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ListSuitesResultJsonUnmarshaller(), executionContext);
            ListSuitesResult listSuitesResult = response.getAwsResponse();
            return listSuitesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTestsResult listTests(ListTestsRequest listTestsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTestsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTestsRequest> request = null;
        Response<ListTestsResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTestsRequestMarshaller().marshall(listTestsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ListTestsResultJsonUnmarshaller(), executionContext);
            ListTestsResult listTestsResult = response.getAwsResponse();
            return listTestsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListUniqueProblemsResult listUniqueProblems(ListUniqueProblemsRequest listUniqueProblemsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listUniqueProblemsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListUniqueProblemsRequest> request = null;
        Response<ListUniqueProblemsResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListUniqueProblemsRequestMarshaller().marshall(listUniqueProblemsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ListUniqueProblemsResultJsonUnmarshaller(), executionContext);
            ListUniqueProblemsResult listUniqueProblemsResult = response.getAwsResponse();
            return listUniqueProblemsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListUploadsResult listUploads(ListUploadsRequest listUploadsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listUploadsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListUploadsRequest> request = null;
        Response<ListUploadsResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListUploadsRequestMarshaller().marshall(listUploadsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ListUploadsResultJsonUnmarshaller(), executionContext);
            ListUploadsResult listUploadsResult = response.getAwsResponse();
            return listUploadsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduleRunResult scheduleRun(ScheduleRunRequest scheduleRunRequest) {
        ExecutionContext executionContext = this.createExecutionContext(scheduleRunRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ScheduleRunRequest> request = null;
        Response<ScheduleRunResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ScheduleRunRequestMarshaller().marshall(scheduleRunRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ScheduleRunResultJsonUnmarshaller(), executionContext);
            ScheduleRunResult scheduleRunResult = response.getAwsResponse();
            return scheduleRunResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, Unmarshaller<X, JsonUnmarshallerContext> unmarshaller, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonResponseHandler<X> responseHandler = new JsonResponseHandler<X>(unmarshaller);
        JsonErrorResponseHandlerV2 errorResponseHandler = new JsonErrorResponseHandlerV2(this.jsonErrorUnmarshallers);
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

