/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest;
import com.amazonaws.services.ec2.model.ExportToS3TaskSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateInstanceExportTaskRequestMarshaller
implements Marshaller<Request<CreateInstanceExportTaskRequest>, CreateInstanceExportTaskRequest> {
    @Override
    public Request<CreateInstanceExportTaskRequest> marshall(CreateInstanceExportTaskRequest createInstanceExportTaskRequest) {
        ExportToS3TaskSpecification exportToS3TaskSpecificationExportToS3Task;
        if (createInstanceExportTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateInstanceExportTaskRequest> request = new DefaultRequest<CreateInstanceExportTaskRequest>(createInstanceExportTaskRequest, "AmazonEC2");
        request.addParameter("Action", "CreateInstanceExportTask");
        request.addParameter("Version", "2015-10-01");
        if (createInstanceExportTaskRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createInstanceExportTaskRequest.getDescription()));
        }
        if (createInstanceExportTaskRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(createInstanceExportTaskRequest.getInstanceId()));
        }
        if (createInstanceExportTaskRequest.getTargetEnvironment() != null) {
            request.addParameter("TargetEnvironment", StringUtils.fromString(createInstanceExportTaskRequest.getTargetEnvironment()));
        }
        if ((exportToS3TaskSpecificationExportToS3Task = createInstanceExportTaskRequest.getExportToS3Task()) != null) {
            if (exportToS3TaskSpecificationExportToS3Task.getDiskImageFormat() != null) {
                request.addParameter("ExportToS3.DiskImageFormat", StringUtils.fromString(exportToS3TaskSpecificationExportToS3Task.getDiskImageFormat()));
            }
            if (exportToS3TaskSpecificationExportToS3Task.getContainerFormat() != null) {
                request.addParameter("ExportToS3.ContainerFormat", StringUtils.fromString(exportToS3TaskSpecificationExportToS3Task.getContainerFormat()));
            }
            if (exportToS3TaskSpecificationExportToS3Task.getS3Bucket() != null) {
                request.addParameter("ExportToS3.S3Bucket", StringUtils.fromString(exportToS3TaskSpecificationExportToS3Task.getS3Bucket()));
            }
            if (exportToS3TaskSpecificationExportToS3Task.getS3Prefix() != null) {
                request.addParameter("ExportToS3.S3Prefix", StringUtils.fromString(exportToS3TaskSpecificationExportToS3Task.getS3Prefix()));
            }
        }
        return request;
    }
}

