/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.DeleteMethodResponseRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteMethodResponseRequestMarshaller
implements Marshaller<Request<DeleteMethodResponseRequest>, DeleteMethodResponseRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<DeleteMethodResponseRequest> marshall(DeleteMethodResponseRequest deleteMethodResponseRequest) {
        if (deleteMethodResponseRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteMethodResponseRequest> request = new DefaultRequest<DeleteMethodResponseRequest>(deleteMethodResponseRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", deleteMethodResponseRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(deleteMethodResponseRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{resource_id}", deleteMethodResponseRequest.getResourceId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(deleteMethodResponseRequest.getResourceId()));
        uriResourcePath = uriResourcePath.replace("{http_method}", deleteMethodResponseRequest.getHttpMethod() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(deleteMethodResponseRequest.getHttpMethod()));
        uriResourcePath = uriResourcePath.replace("{status_code}", deleteMethodResponseRequest.getStatusCode() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(deleteMethodResponseRequest.getStatusCode()));
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

