/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.services.simpleemail.model.ReceiptRule;
import com.amazonaws.services.simpleemail.model.transform.ReceiptActionStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ReceiptRuleStaxUnmarshaller
implements Unmarshaller<ReceiptRule, StaxUnmarshallerContext> {
    private static ReceiptRuleStaxUnmarshaller instance;

    @Override
    public ReceiptRule unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReceiptRule receiptRule = new ReceiptRule();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return receiptRule;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    receiptRule.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Enabled", targetDepth)) {
                    receiptRule.setEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TlsPolicy", targetDepth)) {
                    receiptRule.setTlsPolicy(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Recipients/member", targetDepth)) {
                    receiptRule.getRecipients().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Actions/member", targetDepth)) {
                    receiptRule.getActions().add(ReceiptActionStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ScanEnabled", targetDepth)) continue;
                receiptRule.setScanEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return receiptRule;
    }

    public static ReceiptRuleStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ReceiptRuleStaxUnmarshaller();
        }
        return instance;
    }
}

