/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.ListTrafficPolicyVersionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ListTrafficPolicyVersionsRequestMarshaller
implements Marshaller<Request<ListTrafficPolicyVersionsRequest>, ListTrafficPolicyVersionsRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    @Override
    public Request<ListTrafficPolicyVersionsRequest> marshall(ListTrafficPolicyVersionsRequest listTrafficPolicyVersionsRequest) {
        String value;
        String name;
        if (listTrafficPolicyVersionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListTrafficPolicyVersionsRequest> request = new DefaultRequest<ListTrafficPolicyVersionsRequest>(listTrafficPolicyVersionsRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("Id")) {
            name = DYNAMIC_QUERY_PARAMS.get("Id");
            String string = value = listTrafficPolicyVersionsRequest.getId() == null ? null : StringUtils.fromString(listTrafficPolicyVersionsRequest.getId());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Id}", listTrafficPolicyVersionsRequest.getId() == null ? "" : StringUtils.fromString(listTrafficPolicyVersionsRequest.getId()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("TrafficPolicyVersionMarker")) {
            name = DYNAMIC_QUERY_PARAMS.get("TrafficPolicyVersionMarker");
            String string = value = listTrafficPolicyVersionsRequest.getTrafficPolicyVersionMarker() == null ? null : StringUtils.fromString(listTrafficPolicyVersionsRequest.getTrafficPolicyVersionMarker());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{TrafficPolicyVersionMarker}", listTrafficPolicyVersionsRequest.getTrafficPolicyVersionMarker() == null ? "" : StringUtils.fromString(listTrafficPolicyVersionsRequest.getTrafficPolicyVersionMarker()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("MaxItems")) {
            name = DYNAMIC_QUERY_PARAMS.get("MaxItems");
            String string = value = listTrafficPolicyVersionsRequest.getMaxItems() == null ? null : StringUtils.fromString(listTrafficPolicyVersionsRequest.getMaxItems());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{MaxItems}", listTrafficPolicyVersionsRequest.getMaxItems() == null ? "" : StringUtils.fromString(listTrafficPolicyVersionsRequest.getMaxItems()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        return request;
    }

    static {
        String path = "/2013-04-01/trafficpolicies/{Id}/versions?trafficpolicyversion={TrafficPolicyVersionMarker}&maxitems={MaxItems}";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

