/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesis.model.HashKeyRange;
import com.amazonaws.util.json.JSONWriter;

public class HashKeyRangeJsonMarshaller {
    private static HashKeyRangeJsonMarshaller instance;

    public void marshall(HashKeyRange hashKeyRange, JSONWriter jsonWriter) {
        if (hashKeyRange == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (hashKeyRange.getStartingHashKey() != null) {
                jsonWriter.key("StartingHashKey").value(hashKeyRange.getStartingHashKey());
            }
            if (hashKeyRange.getEndingHashKey() != null) {
                jsonWriter.key("EndingHashKey").value(hashKeyRange.getEndingHashKey());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static HashKeyRangeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new HashKeyRangeJsonMarshaller();
        }
        return instance;
    }
}

