/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListPoliciesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListPoliciesRequestMarshaller
implements Marshaller<Request<ListPoliciesRequest>, ListPoliciesRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<ListPoliciesRequest> marshall(ListPoliciesRequest listPoliciesRequest) {
        String ascendingOrder;
        String pageSize;
        String marker;
        if (listPoliciesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListPoliciesRequest> request = new DefaultRequest<ListPoliciesRequest>(listPoliciesRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/policies";
        request.setResourcePath(uriResourcePath);
        String string = marker = listPoliciesRequest.getMarker() == null ? null : StringUtils.fromString(listPoliciesRequest.getMarker());
        if (marker != null) {
            request.addParameter("marker", marker);
        }
        String string2 = pageSize = listPoliciesRequest.getPageSize() == null ? null : StringUtils.fromInteger(listPoliciesRequest.getPageSize());
        if (pageSize != null) {
            request.addParameter("pageSize", pageSize);
        }
        String string3 = ascendingOrder = listPoliciesRequest.getAscendingOrder() == null ? null : StringUtils.fromBoolean(listPoliciesRequest.getAscendingOrder());
        if (ascendingOrder != null) {
            request.addParameter("isAscendingOrder", ascendingOrder);
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

